package com.liquidnet.service.sweet.controller;


import com.github.pagehelper.PageInfo;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.dto.SweetManualDto;
import com.liquidnet.service.sweet.dto.SweetManualMDSKDto;
import com.liquidnet.service.sweet.service.ISweetManualMdskService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 电子宣传手册表 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2021-08-09
 */
@Api(tags = "电子手册_MDSK")
@RestController
@RequestMapping("/mdsk/sweet-manual-mdsk")
public class SweetManualMdskController {
    @Autowired
    private ISweetManualMdskService sweetManualMdskService;

    @GetMapping("list")
    @ApiOperation("宣传手册列表")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "page", value = "页数", required = true),
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "size", value = "数量", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "name", value = "姓名", required = false),
    })
    public ResponseDto<PageInfo<SweetManualMDSKDto>> getList(@RequestParam() Integer page,
                                                             @RequestParam() Integer size,
                                                             @RequestParam(required = false) String name) {
        return sweetManualMdskService.getManualList(page, size, name);
    }


    @GetMapping("details")
    @ApiOperation("宣传手册详情")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "manualId", value = "手册id"),
    })
    public ResponseDto<SweetManualMDSKDto> details(@RequestParam(required = false) String manualId) {
        return sweetManualMdskService.details(manualId);
    }

    @PostMapping("changeRelease")
    @ApiOperation("修改是否发布")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "page", value = "页数", required = true),
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "size", value = "数量", required = true),
    })
    public ResponseDto<Boolean> changeRelease(@RequestParam() String manualId,
                                              @RequestParam() Integer isRelease) {
        return sweetManualMdskService.changeRelease(manualId, isRelease);
    }

    @PostMapping("changeStatus")
    @ApiOperation("修改是否开启")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "manualId", value = "电子手册id", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "performancesId", value = "演出id", required = true),
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "status", value = "开启状态", required = true),
    })
    public ResponseDto<Boolean> changeStatus(@RequestParam() String manualId,
                                             @RequestParam() String performancesId,
                                             @RequestParam() Integer status) {
        return sweetManualMdskService.changeStatus(manualId, performancesId, status);
    }
}
