package com.liquidnet.service.goblin.param;

import com.liquidnet.service.dragon.dto.DragonPayOrderQueryRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

@ApiModel(value = "GoblinNftOrderPayCallbackParam", description = "支付成功回调所需参数")
@Data
public class GoblinNftOrderPayCallbackParam implements Cloneable {

    @ApiModelProperty(value = "支付状态[1-成功|0-失败]")
    private Integer status;

    @ApiModelProperty(value = "订单ID")
    private String orderId;

    @ApiModelProperty(value = "订单编号")
    private String orderCode;

    @ApiModelProperty(value = "支付code")
    private String code;

    @ApiModelProperty(value = "price")
    private BigDecimal price;

    @ApiModelProperty(value = "type")
    private String type;

    @ApiModelProperty(value = "汇付相关id")
    private String paymentId;

    @ApiModelProperty(value = "paymentType")
    private String paymentType;

    @ApiModelProperty(value = "支付时间")
    private String paymentAt;

    private static final GoblinNftOrderPayCallbackParam obj = new GoblinNftOrderPayCallbackParam();

    public static GoblinNftOrderPayCallbackParam getNew() {
        try {
            return (GoblinNftOrderPayCallbackParam) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinNftOrderPayCallbackParam();
        }
    }

    public GoblinNftOrderPayCallbackParam copy(DragonPayOrderQueryRespDto source) {
        if (null == source) return this;
        this.setStatus(source.getStatus());
//        this.setOrderId(source.getOrderCodeId());
        this.setOrderCode(source.getOrderCode());
        this.setCode(source.getCode());
        this.setPrice(source.getPrice());
        this.setType(source.getType());
        this.setPaymentId(source.getPaymentId());
        this.setPaymentType(source.getPaymentType());
        this.setPaymentAt(source.getPaymentAt());
        return this;
    }
}
