package com.liquidnet.client.admin.zhengzai.admin.service.impl.utils;

import com.liquidnet.commons.lang.util.DateUtil;
import org.springframework.stereotype.Component;

import java.io.*;
import java.time.LocalDateTime;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

/**
 * <p>
 * zip
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-07-20
 */
@Component
public class ZipMultiFileUtil {

//    public static String pathName = "/data/images/tmphtml/";
    public static String fatherPath = "/Users/jiangxiulong/Desktop/tmphtml/faceImg";
//    public static String fileDir = "/data/images/tmphtml/faceImgZip";
    public static String fileDir = "/Users/jiangxiulong/Desktop/tmphtml/faceImgZip";

    public static void zipFiles(File[] srcFiles, File zipFile) {
        try {
            if (srcFiles.length != 0) {
                // 判断压缩后的文件存在不，不存在则创建
                if (!zipFile.exists()) {
                    zipFile.createNewFile();
                } else {
                    zipFile.delete();
                    zipFile.createNewFile();
                }

                // 创建 FileInputStream 对象
                FileInputStream fileInputStream = null;
                // 实例化 FileOutputStream 对象
                FileOutputStream fileOutputStream = new FileOutputStream(zipFile);
                // 实例化 ZipOutputStream 对象
                ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);
                // 创建 ZipEntry 对象
                ZipEntry zipEntry = null;
                // 遍历源文件数组
                for (int i = 0; i < srcFiles.length; i++) {
                    // 将源文件数组中的当前文件读入 FileInputStream 流中
                    fileInputStream = new FileInputStream(srcFiles[i]);
                    // 实例化 ZipEntry 对象，源文件数组中的当前文件
                    zipEntry = new ZipEntry(srcFiles[i].getName());
                    zipOutputStream.putNextEntry(zipEntry);
                    // 该变量记录每次真正读的字节个数
                    int len;
                    // 定义每次读取的字节数组
                    byte[] buffer = new byte[1024];
                    while ((len = fileInputStream.read(buffer)) > 0) {
                        zipOutputStream.write(buffer, 0, len);
                    }
                }
                zipOutputStream.closeEntry();
                zipOutputStream.close();
                fileInputStream.close();
                fileOutputStream.close();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 将存放在sourceFilePath目录下的源文件，打包成fileName名称的zip文件，并存放到zipFilePath路径下
     *
     * @param sourceFilePath :待压缩的文件路径
     * @param zipFilePath    :压缩后存放路径
     * @param fileName       :压缩后文件的名称
     * @return
     */
    public static boolean fileToZip(String sourceFilePath, String zipFilePath, String fileName) {
        boolean flag = false;
        File sourceFile = new File(sourceFilePath);
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        FileOutputStream fos = null;
        ZipOutputStream zos = null;

        if (sourceFile.exists() == false) {
            System.out.println("待压缩的文件目录：" + sourceFilePath + "不存在");
            sourceFile.mkdir(); // 新建目录
        }
        try {
            File zipFile = new File(zipFilePath + "/" + fileName);
            if (zipFile.exists()) {
                System.out.println(zipFilePath + "目录下存在名字为:" + fileName + ".zip" + "打包文件.");
            } else {
                File[] sourceFiles = sourceFile.listFiles();
                if (null == sourceFiles || sourceFiles.length < 1) {
                    System.out.println("待压缩的文件目录：" + sourceFilePath + "里面不存在文件，无需压缩.");
                } else {
                    fos = new FileOutputStream(zipFile);
                    zos = new ZipOutputStream(new BufferedOutputStream(fos));
                    byte[] bufs = new byte[1024 * 10];
                    for (int i = 0; i < sourceFiles.length; i++) {
                        //创建ZIP实体，并添加进压缩包
                        ZipEntry zipEntry = new ZipEntry(sourceFiles[i].getName());
                        zos.putNextEntry(zipEntry);
                        //读取待压缩的文件并写进压缩包里
                        fis = new FileInputStream(sourceFiles[i]);
                        bis = new BufferedInputStream(fis, 1024 * 10);
                        int read = 0;
                        while ((read = bis.read(bufs, 0, 1024 * 10)) != -1) {
                            zos.write(bufs, 0, read);
                        }
                    }
                    flag = true;
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        } finally {
            //关闭流
            try {
                if (null != bis) bis.close();
                if (null != zos) zos.close();
            } catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        return flag;
    }

    public static String goZip() {
        //创建父级目录 用于存放分区（分区中存放多个分类）
        String fileName = "faceImgs".concat(DateUtil.format(LocalDateTime.now(), DateUtil.Formatter.yyyyMMddHHmmssTrim));

        File fatherFile = new File(fileDir);
        try {
            if (!fatherFile.exists()) {
                fatherFile.mkdir();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

        //将项目名称的文件夹 压缩为zip
        boolean res = ZipMultiFileUtil.fileToZip(fatherPath, fileDir, fileName + ".zip");
        if (res) {
            return fileDir.concat("/").concat(fileName).concat(".zip");
        } else {
            return "";
        }
    }

    /*public static void main(String[] args) {
        goZip();
    }*/
}
