package com.liquidnet.service.adam.dto.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.adam.entity.AdamUserMember;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

@ApiModel(value = "AdamUserMemberVo", description = "会员用户信息")
@Data
@JsonIgnoreProperties(value = {"uid"}, ignoreUnknown = true)
public class AdamUserMemberVo implements Serializable, Cloneable {
    private static final long serialVersionUID = 9027553500608702757L;
    @ApiModelProperty(position = 11, value = "用户ID")
    private String uid;
    @ApiModelProperty(position = 12, value = "会员类型ID")
    private String memberId;
    @ApiModelProperty(position = 13, value = "会员号")
    private String memberNo;
    @ApiModelProperty(position = 14, value = "用户会员状态[1-NORMAL,2-INVALID]")
    private Integer state;
    @ApiModelProperty(position = 15, value = "过期时间")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern= DateUtil.DATE_FULL_STR)
    private LocalDateTime expiryAt;
    @ApiModelProperty(position = 16, value = "创建时间")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern= DateUtil.DATE_FULL_STR)
    private LocalDateTime createdAt;
    @ApiModelProperty(position = 17, value = "更新时间")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern= DateUtil.DATE_FULL_STR)
    private LocalDateTime updatedAt;

    public static final LocalDateTime spotTime = LocalDateTime.parse("2021-10-14 21:30:00", DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
    private static final AdamUserMemberVo obj = new AdamUserMemberVo();

    public static AdamUserMemberVo getNew() {
        try {
            return (AdamUserMemberVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new AdamUserMemberVo();
        }
    }

    public AdamUserMemberVo copy(AdamUserMember source) {
        if (null == source) return this;
        this.setUid(source.getUid());
        this.setMemberId(source.getMemberId());
        this.setMemberNo(source.getMemberNo());
        this.setState(source.getState());
        this.setExpiryAt(source.getExpiryAt());
        this.setCreatedAt(source.getCreatedAt());
        this.setUpdatedAt(source.getUpdatedAt());
        return this;
    }

    /**
     * 会员是否有效
     *
     * @return true-有效
     */
    @JsonIgnore
    public boolean isActive() {
        LocalDateTime expiryAt = this.getExpiryAt();
        return this.getState() == 1 && null != expiryAt && expiryAt.isAfter(LocalDateTime.now());
    }

    /**
     * 是否为老会员
     * <p>
     * 实际使用中需结合isActive()判断
     * </p>
     *
     * @return true-是
     */
    @JsonIgnore
    public boolean isOldMember() {
        LocalDateTime createdAt = this.getCreatedAt();
        LocalDateTime updatedAt = this.getUpdatedAt();
        // 创建时间在`指定时间`之前，且（更新时间为空或更新时间在`指定时间`之前）
        return createdAt.isBefore(spotTime) && (null == updatedAt || (updatedAt.isBefore(spotTime)));
    }
}