package com.liquidnet.client.admin.web.controller.zhengzai.kylin;

import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.model.PutObjectRequest;
import com.github.pagehelper.PageInfo;
import com.liquidnet.client.admin.common.config.RuoYiConfig;
import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.common.core.page.TableDataInfo;
import com.liquidnet.client.admin.common.enums.BannersDisplayLocation;
import com.liquidnet.client.admin.common.enums.BannersTargetType;
import com.liquidnet.client.admin.common.utils.file.FileUploadUtils;
import com.liquidnet.client.admin.zhengzai.kylin.service.impl.KylinBannersServiceImpl;
import com.liquidnet.commons.lang.util.FilesUtils;
import com.liquidnet.service.kylin.dao.BannerDetailsListDao;
import com.liquidnet.service.kylin.dto.param.BannersParam;
import com.liquidnet.service.kylin.dto.param.BannersSearchParam;
import com.liquidnet.service.kylin.dto.vo.KylinBannersVo;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;

/**
 * <p>
 * 轮播图 后端管理控制器
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-05-01
 */

@Controller
@RequestMapping("/kylin/banners")
public class KylinBannersAdminController extends BaseController {

    private String prefix = "zhengzai/kylin/banners";

    @Value("${liquidnet.url-banner.provinces}")
    private String provinces;
    @Value("${liquidnet.url-banner.url1}")
    private String url1;
    @Value("${liquidnet.url-banner.url2}")
    private String url2;
    @Value("${liquidnet.url-banner.url5}")
    private String url5;
    @Value("${liquidnet.url-banner.url6}")
    private String url6;
    @Value("${liquidnet.url-banner.url7}")
    private String url7;
    @Value("${liquidnet.url-banner.url8}")
    private String url8;
    @Value("${liquidnet.url-banner.url13}")
    private String url13;
    @Value("${liquidnet.url-banner.url14}")
    private String url14;
    @Value("${liquidnet.url-banner.url20}")
    private String url20;
    @Value("${liquidnet.url-banner.url21}")
    private String url21;
    @Value("${liquidnet.url-banner.url22}")
    private String url22;
    @Value("${liquidnet.url-banner.url23}")
    private String url23;
    @Value("${liquidnet.url-banner.url24}")
    private String url24;
    @Value("${liquidnet.url-banner.url26}")
    private String url26;

    @Value("${liquidnet.al-oss.endpoint}")
    private String endpoint;
    @Value("${liquidnet.al-oss.accessKeyId}")
    private String accessKeyId;
    @Value("${liquidnet.al-oss.accessKeySecret}")
    private String accessKeySecret;

    @Autowired
    private KylinBannersServiceImpl kylinBannersServiceImpl;

    @RequiresPermissions("kylin:banners:view")
    @GetMapping()
    public String banners() {
        return prefix + "/banners";
    }

    @GetMapping("/create")
    public String create(ModelMap mmap) {
        List<Object> bannersTargetType = BannersTargetType.getResultType();
        List<Object> bannersDisplayLocation = BannersDisplayLocation.getResultType();
        mmap.put("BannersTargetType", bannersTargetType);
        mmap.put("BannersDisplayLocation", bannersDisplayLocation);

        mmap.put("provinces", provinces);
        mmap.put("url1", url1);
        mmap.put("url2", url2);
        mmap.put("url5", url5);
        mmap.put("url6", url6);
        mmap.put("url7", url7);
        mmap.put("url8", url8);
        mmap.put("url13", url13);
        mmap.put("url14", url14);
        mmap.put("url20", url20);
        mmap.put("url21", url21);
        mmap.put("url22", url22);
        mmap.put("url23", url23);
        mmap.put("url24", url24);
        mmap.put("url26", url26);

        return prefix + "/create";
    }

    @RequiresPermissions("kylin:banners:create")
    @PostMapping("create")
    @ResponseBody
    public AjaxResult createSave(BannersParam bannersParam) {
        Boolean res = kylinBannersServiceImpl.create(bannersParam);
        if (res) {
            return success();
        } else {
            return error("添加banner失败");
        }
    }

    @GetMapping("/update/{bannersId}")
    public String update(@PathVariable("bannersId") String bannersId, ModelMap mmap) {
        KylinBannersVo result = null;
        result = kylinBannersServiceImpl.detail(bannersId);

        List<Object> bannersTargetType = BannersTargetType.getResultType();
        List<Object> bannersDisplayLocation = BannersDisplayLocation.getResultType();

        mmap.put("KylinBannersVo", result);

        mmap.put("BannersTargetType", bannersTargetType);
        mmap.put("BannersDisplayLocation", bannersDisplayLocation);

        mmap.put("provinces", provinces);
        mmap.put("url1", url1);
        mmap.put("url2", url2);
        mmap.put("url5", url5);
        mmap.put("url6", url6);
        mmap.put("url7", url7);
        mmap.put("url8", url8);
        mmap.put("url13", url13);
        mmap.put("url14", url14);
        mmap.put("url20", url20);
        mmap.put("url21", url21);
        mmap.put("url22", url22);
        mmap.put("url23", url23);
        mmap.put("url24", url24);
        mmap.put("url26", url26);

        return prefix + "/update";
    }

    @RequiresPermissions("kylin:banners:update")
    @PostMapping("update")
    @ResponseBody
    public AjaxResult updateSave(BannersParam bannersParam) {
        boolean res = kylinBannersServiceImpl.update(bannersParam);
        if (res) {
            return success();
        } else {
            return error("修改banner失败");
        }
    }

    /*@RequiresPermissions("kylin:banners:detail")
    @GetMapping("/details/{bannersId}")
    public String detail(@PathVariable("bannersId") String bannersId, ModelMap mmap) {
        KylinBannersVo result = null;
        result = kylinBannersServiceImpl.detail(bannersId);
        mmap.put("KylinBannersVo", result);
        return prefix + "/details";
    }*/

    @RequiresPermissions("kylin:banners:list")
    @PostMapping("list")
    @ResponseBody
    public TableDataInfo bannerList(BannersSearchParam bannersSearchParam) {
        PageInfo<BannerDetailsListDao> result = kylinBannersServiceImpl.bannerList(bannersSearchParam);
        return getDataTable(result.getList());
    }

    @RequiresPermissions("kylin:banners:delete")
    @PostMapping("delete")
    @ResponseBody
    public AjaxResult delete(BannersParam bannersParam) {
        List<String> bannersId = bannersParam.getIds();
        boolean result = kylinBannersServiceImpl.delete(bannersId);
        if (result) {
            return success("删除成功");
        } else {
            return error("删除失败");
        }
    }

    /**
     * 文件上传
     */
    @PostMapping("/upload1")
    @ResponseBody
    public String upload1(@RequestParam MultipartFile coverImg) {
        try {
            if (!coverImg.isEmpty()) {
                String avatar = FileUploadUtils.upload(RuoYiConfig.getAvatarPath(), coverImg);
                return avatar;
            }
            return "error";
        } catch (Exception e) {
            return "success";
        }
    }

    @PostMapping("/upload2")
    @ResponseBody
    public String upload2(@RequestParam MultipartFile coverImg) {
        if (coverImg.isEmpty()) {
            return "上传失败，请选择文件";
        }

        String fileName = coverImg.getOriginalFilename();
        String filePath = RuoYiConfig.getAvatarPath();
        File dest = new File(filePath + fileName);
        try {
            coverImg.transferTo(dest);
            return dest.getName();
        } catch (IOException e) {
            return "上传失败！";
        }
    }

    @PostMapping("/upload3")
    @ResponseBody
    public HashMap upload3(@RequestParam MultipartFile coverImgFile) {
        OSS ossClient = new OSSClientBuilder().build(endpoint, accessKeyId, accessKeySecret);

        File file = null;
        try {
            file = FilesUtils.multipartFileToFile(coverImgFile);
        } catch (Exception e) {
            return new HashMap<>();
        }

        String filename = coverImgFile.getResource().getFilename();// time.jpeg
        //这里文件名用了uuid 防止重复，可以根据自己的需要来写
        String uploadName = UUID.randomUUID() + filename.substring(filename.lastIndexOf("."));// 078a77e0-cf80-481b-824c-5935247cff15.jpeg
        uploadName = uploadName.replace("-", "");// 078a77e0cf80481b824c5935247cff15.jpeg
        String uploadpath = "banner/" + uploadName;
        PutObjectRequest putObjectRequest = new PutObjectRequest("img-zhengzai-tv", uploadpath, file);
        ossClient.putObject(putObjectRequest);

        ossClient.shutdown();
        file.delete();

        HashMap<Object, Object> objectObjectHashMap = new HashMap<>();
        objectObjectHashMap.put("uploadpath", uploadpath);
        return objectObjectHashMap;
    }

}
