package com.liquidnet.service.dragon.channel.alipay.biz;

import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.dragon.constant.DragonConstant;
import com.liquidnet.service.dragon.dto.DragonPayBaseReqDto;
import com.liquidnet.service.dragon.dto.DragonPayBaseRespDto;
import com.liquidnet.service.dragon.entity.DragonOrders;
import com.liquidnet.service.dragon.utils.MqHandleUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: AlipayBiz
 * @Package com.liquidnet.service.dragon.channel.alipay.biz
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2021/7/10 16:21
 */
@Component
public class AlipayBiz {
    @Autowired
    private MqHandleUtil mqHandleUtil;

    public DragonOrders buildPayOrders(DragonPayBaseReqDto dragonPayBaseReqDto, DragonPayBaseRespDto respDto){
        DragonOrders orders = new DragonOrders();
//        orders.setMid();
        orders.setStatus(Integer.valueOf(DragonConstant.PayStatusEnum.STATUS_UNPAID.getCode()));
        orders.setCode(respDto.getCode());
        orders.setType(dragonPayBaseReqDto.getType());
        orders.setPrice(dragonPayBaseReqDto.getPrice());
        orders.setName(dragonPayBaseReqDto.getName());
        orders.setDetail(dragonPayBaseReqDto.getDetail());
        orders.setOrderCode(dragonPayBaseReqDto.getOrderCode());
        orders.setClientIp(dragonPayBaseReqDto.getClientIp());
        orders.setNotifyUrl(dragonPayBaseReqDto.getNotifyUrl());
        orders.setPaymentType(DragonConstant.PayTypeEnum.PAYMENT_TYPE_APP_IAP.getCode());
//        orders.setPaymentId();
        orders.setPaymentAt(LocalDateTime.now());
//        orders.setFinishedAt();
        orders.setCreatedAt(LocalDateTime.now());
//        orders.setUpdatedAt();
        // 修改退款订单
        boolean insertResult = mqHandleUtil.sendMySqlRedis(
                SqlMapping.get("dragon_orders.insert"),
                new Object[]{orders.getStatus(), orders.getCode(), orders.getType()
                        , orders.getPrice(), orders.getName(), orders.getDetail()
                        , orders.getOrderCode(), orders.getClientIp()
                        , orders.getNotifyUrl(), orders.getPaymentType(),
                        orders.getPaymentId(), orders.getPaymentAt()
                        , orders.getFinishedAt(), orders.getCreatedAt()
                        , orders.getUpdatedAt()}
        );
        return orders;
    }
}
