package com.liquidnet.service.platform.controller.express.shunfeng;

import com.liquidnet.service.kylin.dto.param.PerformanceExpressPushFreightParam;
import com.liquidnet.service.kylin.dto.param.PerformanceExpressPushRouteParam;
import com.liquidnet.service.kylin.dto.param.PerformanceExpressPushStatusParam;
import com.liquidnet.service.platform.service.express.shunfeng.PerformancesExpressCallbackServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;

/**
 * <p>
 * 演出快递 顺丰推送
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-06-29
 */

@Api(tags = "前端-shunfengCallBack")
@RestController
@RequestMapping("performancesExpress")
public class PerformancesExpressCallbackController {

    @Autowired
    private PerformancesExpressCallbackServiceImpl performancesExpressServiceImpl;

    @PostMapping("orderStatus")
    @ApiOperation("订单状态推送")
    public HashMap OrderStatus(PerformanceExpressPushStatusParam performanceExpressPushStatusParam) {
        boolean result = performancesExpressServiceImpl.orderStatus(performanceExpressPushStatusParam);
        HashMap<Object, Object> objectObjectHashMap = new HashMap<>();
        if (result) {
            objectObjectHashMap.put("status", "OK");
        } else {
            objectObjectHashMap.put("status", "ERR");
        }
        return objectObjectHashMap;
    }

    @PostMapping("orderRoute")
    @ApiOperation("路由推送")
    public HashMap listOrderRoute(PerformanceExpressPushRouteParam performanceExpressPushRouteParam) {
        boolean result = performancesExpressServiceImpl.orderRoute(performanceExpressPushRouteParam);
        HashMap<Object, Object> objectObjectHashMap = new HashMap<>();
        if (result) {
            objectObjectHashMap.put("status", "OK");
        } else {
            objectObjectHashMap.put("status", "ERR");
        }
        return objectObjectHashMap;
    }

    @PostMapping("orderFreightList")
    @ApiOperation("清单运费推送")
    public HashMap getListFreight(PerformanceExpressPushFreightParam performanceExpressPushFreightParam) {
        boolean result = performancesExpressServiceImpl.orderFreightList(performanceExpressPushFreightParam);
        HashMap<Object, Object> objectObjectHashMap = new HashMap<>();
        if (result) {
            objectObjectHashMap.put("status", "OK");
        } else {
            objectObjectHashMap.put("status", "ERR");
        }
        return objectObjectHashMap;
    }

}
