package com.liquidnet.service.order.service.impl;

import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.common.sms.constant.SmsEnum;
import com.liquidnet.commons.lang.util.*;
import com.liquidnet.service.adam.dto.vo.AdamAddressesVo;
import com.liquidnet.service.adam.dto.vo.AdamEntersVo;
import com.liquidnet.service.base.*;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.kylin.constant.KylinRedisConst;
import com.liquidnet.service.kylin.constant.KylinTableStatusConst;
import com.liquidnet.service.kylin.dto.param.PayAgainParam;
import com.liquidnet.service.kylin.dto.param.PayOrderParam;
import com.liquidnet.service.kylin.dto.param.SyncOrderDtoParam;
import com.liquidnet.service.kylin.dto.param.SyncOrderParam;
import com.liquidnet.service.kylin.dto.vo.middle.KylinTicketTimesVo;
import com.liquidnet.service.kylin.dto.vo.middle.KylinTicketVo;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinOrderTicketEntitiesVo;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinOrderTicketVo;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinPerformanceVo;
import com.liquidnet.service.kylin.dto.vo.returns.PayInnerResultVo;
import com.liquidnet.service.kylin.dto.vo.returns.PayResultVo;
import com.liquidnet.service.kylin.entity.KylinOrderTicketEntities;
import com.liquidnet.service.kylin.entity.KylinOrderTicketRelations;
import com.liquidnet.service.kylin.entity.KylinOrderTicketStatus;
import com.liquidnet.service.kylin.entity.KylinOrderTickets;
import com.liquidnet.service.kylin.service.IKylinOrderTicketsOrderService;
import com.liquidnet.service.order.utils.*;
import com.taobao.api.TaobaoClient;
import com.taobao.api.request.AlibabaDamaiMevOpenBatchpushticketRequest;
import com.taobao.api.response.AlibabaDamaiMevOpenBatchpushticketResponse;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.*;


/**
 * <p>
 * 订单 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-20
 */
@Service
@Slf4j
public class KylinOrderTicketsServiceImpl implements IKylinOrderTicketsOrderService {

    @Value("${liquidnet.url-pay.pay}")
    private String payUrl;
    @Value("${liquidnet.url-pay.check}")
    private String checkUrl;
    @Value("${liquidnet.url-pay.localUrl}")
    private String synUrl;

    @Autowired
    private DataUtils dataUtils;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private OrderUtils orderUtils;
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private MongoConverter mongoConverter;
    @Autowired
    private QueueUtils queueUtils;
    @Autowired
    private TaobaoTicketUtils taobaoTicketUtils;
    @Autowired
    private OrderRefundOvertimeServiceImpl orderRefundsCallbackService;

    ArrayList<Integer> canBuyStatus = new ArrayList() {{
        add(6);
        add(8);
        add(9);
        add(10);
    }};

    @Override
    public ResponseDto<PayInnerResultVo> checkCanOrder(PayOrderParam payOrderParam) {
        Long currentTime;
        boolean isDownGeneral = false;
        List<AdamEntersVo> entersVoList = ObjectUtil.cloneArrayListObject();
        String uid = CurrentUtil.getCurrentUid();
        try {
            currentTime = System.currentTimeMillis();
            KylinPerformanceVo performanceData = dataUtils.getPerformanceVo(payOrderParam.getPerformanceId());
            currentTime = System.currentTimeMillis() - currentTime;
            log.debug("redis 获取演出详情 -> time:" + currentTime + "毫秒");
            KylinTicketTimesVo ticketTimesData = null;
            KylinTicketVo ticketData = null;
            for (int x = 0; x < performanceData.getTicketTimeList().size(); x++) {
                KylinTicketTimesVo timeItem = performanceData.getTicketTimeList().get(x);
                if (timeItem.getTimeId().equals(payOrderParam.getTimeId())) {
                    ticketTimesData = timeItem;
                    for (int y = 0; y < ticketTimesData.getTicketList().size(); y++) {
                        KylinTicketVo ticketItem = ticketTimesData.getTicketList().get(y);
                        if (ticketItem.getTicketsId().equals(payOrderParam.getTicketId())) {
                            ticketData = ticketItem;
                            break;
                        }
                    }
                    break;
                }
            }

            if (payOrderParam.getIsExpress().equals(1) && ticketData.getIsExpress().equals(0)) {
                return ResponseDto.failure("票种类型错误");//参数错误
            } else if (payOrderParam.getIsElectronic().equals(1) && ticketData.getIsElectronic().equals(0)) {
                return ResponseDto.failure("票种类型错误");//参数错误
            }


            if (performanceData == null || ticketTimesData == null || ticketData == null) {
                return ResponseDto.failure(ErrorMapping.get("20004"));//参数错误
            }
            if (!ticketData.getTimeId().equals(payOrderParam.getTimeId()) || !ticketTimesData.getPerformanceId().equals(payOrderParam.getPerformanceId())) {
                return ResponseDto.failure(ErrorMapping.get("20004"));//参数错误
            }
            if (payOrderParam.getNumber() % ticketData.getCounts() != 0) {
                return ResponseDto.failure(ErrorMapping.get("20007"));//数量错误
            }
            //判断代理
            if (!checkAgent(payOrderParam.getAgentId(), ticketData)) {
                return ResponseDto.failure(ErrorMapping.get("20008"));//无权购买
            }

            Integer isStudent = ticketData.getIsStudent();
            //会员时间获取
            String memberTimeStart = ticketData.getMemberTimeStart(); // 会员开售时间
            String timeStart = ticketData.getTimeStart(); // 普通开售时间
            String timeEnd = ticketData.getTimeEnd(); // 购票停售时间
            String timeExpressEnd = ticketData.getTimeEndExpress(); // 快递停售时间
            currentTime = System.currentTimeMillis();
            boolean isMember = orderUtils.isMember(uid);//feignAdamBaseClient.isMember(uid).getData();//获取是否是会员
            currentTime = System.currentTimeMillis() - currentTime;
            log.debug("fegin 会员 -> time:" + (currentTime) + "毫秒");
            int memberType; //会员状态 不需要判断会员 1判断会员逻辑 2会员专属
            if (ticketData.getIsExclusive() == 1) {
                memberType = 2;
                if (!isMember) {
                    return ResponseDto.failure(ErrorMapping.get("20009"));//没有会员权限
                }
            } else {
                if (DateUtil.compareStrDay(DateUtil.getNowTime(), memberTimeStart) == 1 && DateUtil.compareStrDay(DateUtil.getNowTime(), timeStart) == -1 && ticketData.getIsMember() == 1) {
                    // 会员购买逻辑
                    memberType = 1;
                    if (!isMember) {
                        return ResponseDto.failure(ErrorMapping.get("20009"));//没有会员权限
                    }
                } else {
                    // 普通用户购买逻辑
                    memberType = 0;
                }
            }

            // 获取限购 实名
            int ticketLimit = ticketData.getLimitCount();//普通票种限购
            int ticketMemberLimit = ticketData.getLimitCountMember();//会员票种限购
            int performanceLimit = performanceData.getLimitCount();//普通演出限购
            int performanceMemberLimit = performanceData.getLimitCountMember();//会员演出限购
            int isTrueName = ticketData.getIsTrueName();//是否演出实名

            if (!canBuyStatus.contains(performanceData.getAppStatus())) {
                return ResponseDto.failure(ErrorMapping.get("20010"));//当前不可购买
            }

            if (!canBuyStatus.contains(performanceData.getAppStatus())) {
                return ResponseDto.failure(ErrorMapping.get("20010"));//当前不可购买
            }

            //通用判断时间
            if (isMember) {
                if (DateUtil.compareStrDay(DateUtil.getNowTime(), memberTimeStart) == -1) {
                    return ResponseDto.failure(ErrorMapping.get("20011"));//未开始
                }
            } else {
                if (DateUtil.compareStrDay(DateUtil.getNowTime(), timeStart) == -1) {
                    return ResponseDto.failure(ErrorMapping.get("20011"));//未开始
                }
            }
            if (DateUtil.compareStrDay(DateUtil.getNowTime(), timeEnd) == 1) {
                return ResponseDto.failure(ErrorMapping.get("20012"));//已结束
            }

            //快递票判断
            if (payOrderParam.getIsExpress() != null) {
                if (payOrderParam.getIsExpress() == 1 && DateUtil.compareStrDay(DateUtil.getNowTime(), timeExpressEnd) == 1) {
                    return ResponseDto.failure(ErrorMapping.get("20013"));//快递票不卖
                }
                if (payOrderParam.getIsExpress() == 1 && payOrderParam.getAddressId().isEmpty()) {
                    return ResponseDto.failure(ErrorMapping.get("20014"));//快递票未填写收货地址
                }
            }
            //实名判断
            if (isTrueName == 1 && payOrderParam.getEnterIdList().size() <= 0) {
                return ResponseDto.failure(ErrorMapping.get("20015"));//需要实名 未实名
            }
            if (isTrueName == 1 && payOrderParam.getEnterIdList().size() != payOrderParam.getNumber()) {
                return ResponseDto.failure(ErrorMapping.get("20015"));//入场人数量错误
            }

            // 判断库存

            currentTime = System.currentTimeMillis();
            int surplusGeneral = dataUtils.changeSurplusGeneral(payOrderParam.getTicketId(), -payOrderParam.getNumber());
            currentTime = System.currentTimeMillis() - currentTime;
            log.debug("redis 获取库存 -> time:" + (currentTime) + "毫秒");
            log.debug("TAG_REDIS 正常 剩余库存 -> count:" + surplusGeneral);

            if (surplusGeneral < 0) {//库存回滚
                currentTime = System.currentTimeMillis();
                dataUtils.changeSurplusGeneral(payOrderParam.getTicketId(), payOrderParam.getNumber());
                currentTime = System.currentTimeMillis() - currentTime;
                log.debug("redis 修改库存 售罄 -> time:" + (currentTime) + "毫秒");
                log.debug("TAG_REDIS 售罄 回滚库存1 -> count:" + payOrderParam.getNumber());
                return ResponseDto.failure(ErrorMapping.get("20016"));//没抢到
            } else {
                isDownGeneral = true;

                //学生票 判断
                entersVoList = ObjectUtil.cloneArrayListObject();
                if (isTrueName == 1) {
                    currentTime = System.currentTimeMillis();
                    for (String enterId : payOrderParam.getEnterIdList()) {
                        AdamEntersVo adamEnters = orderUtils.getEnters(uid, enterId);//feignAdamBaseClient.queryEnters(enterId, uid).getData();
                        entersVoList.add(adamEnters);
                        if (isStudent == 1) {
                            int age = IDCard.getAgeByIdCard(adamEnters.getIdCard());
                            if (age > 25) {
                                dataUtils.changeSurplusGeneral(payOrderParam.getTicketId(), payOrderParam.getNumber());
                                log.debug("TAG_REDIS 学生票 回滚库存2 -> count:" + payOrderParam.getNumber());
                                return ResponseDto.failure(ErrorMapping.get("20017"));//年龄超了
                            }
                        }
                    }
                    currentTime = System.currentTimeMillis() - currentTime;
                    log.debug("获取 feign 入场人 -> time:" + (currentTime) + "毫秒");
                }

                //限购判断 如果实名 则身份证维度限购 如果不实名则数量限购
                if (entersVoList.size() > 0) {
                    currentTime = System.currentTimeMillis();
                    for (int i = 0; i < entersVoList.size(); i++) {
                        String res1 = orderUtils.judgeOrderLimit(performanceData.getType(), uid, entersVoList.get(i).getIdCard(), payOrderParam.getPerformanceId(), payOrderParam.getTicketId(), performanceLimit, performanceMemberLimit, ticketLimit, ticketMemberLimit, 1, 1, memberType, isTrueName);
                        log.debug("redis 判断库存 -> time:" + (currentTime) + "毫秒");
                        if (!res1.equals("")) {
                            dataUtils.changeSurplusGeneral(payOrderParam.getTicketId(), payOrderParam.getNumber());
                            log.debug("TAG_REDIS 限购 回滚库存3 -> count:" + payOrderParam.getNumber());
                            return ResponseDto.failure(res1);//乱七八糟异常
                        }
                    }
                    currentTime = System.currentTimeMillis() - currentTime;

                } else {
                    log.debug("redis 判断库存 -> time:" + (currentTime) + "毫秒");
                    currentTime = System.currentTimeMillis();
                    String res1 = orderUtils.judgeOrderLimit(performanceData.getType(), uid, "", payOrderParam.getPerformanceId(), payOrderParam.getTicketId(), performanceLimit, performanceMemberLimit, ticketLimit, ticketMemberLimit, payOrderParam.getNumber(), payOrderParam.getNumber(), memberType, isTrueName);
                    currentTime = System.currentTimeMillis() - currentTime;
                    if (!res1.equals("")) {
                        dataUtils.changeSurplusGeneral(payOrderParam.getTicketId(), payOrderParam.getNumber());
                        log.debug("TAG_REDIS 限购 回滚库存3 -> count:" + payOrderParam.getNumber());
                        return ResponseDto.failure(res1);//乱七八糟异常
                    }
                    currentTime = System.currentTimeMillis() - currentTime;

                }

                ResponseDto<PayInnerResultVo> resultData = order(payOrderParam, uid, isMember, isTrueName, performanceData, ticketData, entersVoList, isStudent, ticketTimesData, currentTime);
                isDownGeneral = false;
                return resultData;
            }
        } catch (Exception e) {
            log.error("Kylin Order Pay Error = ", e);
            if (isDownGeneral) {
                currentTime = System.currentTimeMillis();
                dataUtils.changeSurplusGeneral(payOrderParam.getTicketId(), payOrderParam.getNumber());
                log.debug("TAG_REDIS 异常 回滚库存4 -> count:" + payOrderParam.getNumber());
                currentTime = System.currentTimeMillis() - currentTime;
                log.debug("redis 修改库存 异常 -> time:" + (currentTime) + "毫秒");
                for (AdamEntersVo enters : entersVoList) {
                    dataUtils.changeBuyInfo(uid, enters.getIdCard(), payOrderParam.getPerformanceId(), payOrderParam.getTicketId(), -1);
                }
                if (entersVoList.size() == 0) {
                    for (int i = 0; i < payOrderParam.getNumber(); i++) {
                        dataUtils.changeBuyInfo(uid, "", payOrderParam.getPerformanceId(), payOrderParam.getTicketId(), -1);
                    }
                }
            }
            return ResponseDto.failure(ErrorMapping.get("20018"));//乱七八糟异常
        }
    }

    private ResponseDto<PayInnerResultVo> order(PayOrderParam payOrderParam, String uid, boolean isMember, int isTrueName, KylinPerformanceVo performanceData, KylinTicketVo ticketData, List<AdamEntersVo> entersVoList, Integer isStudent, KylinTicketTimesVo ticketTimesData, Long currentTime) {
        LinkedList<String> sqls = ObjectUtil.cloneLinkedListStr();
        String headerCliSource = CurrentUtil.getHeaderCliSource(), headerCliVersion = CurrentUtil.getHeaderCliVersion();
        String source = headerCliSource == null ? "" : headerCliSource;
        String version = headerCliVersion == null ? "" : headerCliVersion;
        LocalDateTime now = LocalDateTime.now();
        //生成订单 order_ticket
        KylinOrderTickets orderTickets = KylinOrderTickets.getNew();
        String orderTicketId = IDGenerator.nextSnowId();
        orderTickets.setOrderTicketsId(orderTicketId);
        orderTickets.setUserId(uid);
        Map token = CurrentUtil.getTokenClaims();
        orderTickets.setUserName(StringUtils.defaultString(((String) token.get("nickname")), ""));
        orderTickets.setUserMobile(StringUtils.defaultString(((String) token.get("mobile")), ""));
        orderTickets.setPerformanceTitle(performanceData.getTitle());
        orderTickets.setOrderCode(IDGenerator.ticketOrderCode(orderTicketId));
        orderTickets.setPayCode("");
        orderTickets.setQrCode("");
        orderTickets.setOrderType(source);
        orderTickets.setOrderVersion(version);
        orderTickets.setNumber(payOrderParam.getNumber());
        orderTickets.setPrice(ticketData.getPrice());
        orderTickets.setPriceMember(ticketData.getMemberPrice());
        if (isMember) {
            orderTickets.setPriceTotal(ticketData.getMemberPrice().multiply(BigDecimal.valueOf(payOrderParam.getNumber())).add(payOrderParam.getIsExpress() == 1 ? ticketData.getPriceExpress() : BigDecimal.valueOf(0)));
        } else {
            orderTickets.setPriceTotal(ticketData.getPrice().multiply(BigDecimal.valueOf(payOrderParam.getNumber())).add(payOrderParam.getIsExpress() == 1 ? ticketData.getPriceExpress() : BigDecimal.valueOf(0)));
        }
        orderTickets.setPriceActual(orderTickets.getPriceTotal());
        orderTickets.setPriceVoucher(BigDecimal.valueOf(0.0));
        orderTickets.setPriceExpress(payOrderParam.getIsExpress() == 1 ? ticketData.getPriceExpress() : BigDecimal.valueOf(0));
        orderTickets.setPriceRefund(BigDecimal.valueOf(0.0));
        orderTickets.setRefundNumber(0);
        orderTickets.setPayType(payOrderParam.getPayType());
        orderTickets.setPaymentType(null);
        orderTickets.setTimePay(null);
        if (payOrderParam.getIsExpress() == 1) {
            currentTime = System.currentTimeMillis();
            AdamAddressesVo addressesVo = orderUtils.getAddress(uid, payOrderParam.getAddressId());//feignAdamBaseClient.queryAddresses(payOrderParam.getAddressId(), uid).getData();
            orderTickets.setExpressContacts(addressesVo.getName());
            orderTickets.setExpressAddress(addressesVo.getProvince() + addressesVo.getCity() + addressesVo.getCounty() + addressesVo.getAddress());
            orderTickets.setExpressPhone(addressesVo.getPhone());
            orderTickets.setCity(addressesVo.getCity());
            orderTickets.setProvince(addressesVo.getProvince());
            orderTickets.setCounty(addressesVo.getCounty());
            orderTickets.setGetTicketType("express");
            currentTime = System.currentTimeMillis() - currentTime;
            log.debug("feign 获取入场人 -> time:" + (currentTime) + "毫秒");
        } else {
            orderTickets.setExpressContacts("");
            orderTickets.setExpressAddress("");
            orderTickets.setExpressPhone("");
            orderTickets.setCity("");
            orderTickets.setProvince("");
            orderTickets.setCounty("");
            orderTickets.setGetTicketType("electronic");
        }
        orderTickets.setCouponType("no");
        orderTickets.setGetTicketDescribe("");
        orderTickets.setPayCountdownMinute(performanceData.getPayCountdownMinute());
        orderTickets.setCreatedAt(now);
        orderTickets.setUpdatedAt(null);


        //生成订单 order_ticket_status
        KylinOrderTicketStatus orderTicketStatus = KylinOrderTicketStatus.getNew();
        String orderTicketStatusId = IDGenerator.nextSnowId();
        orderTicketStatus.setOrderTicketStatusId(orderTicketStatusId);
        orderTicketStatus.setOrderId(orderTicketId);
        orderTicketStatus.setExpressType(payOrderParam.getExpressType());
        orderTicketStatus.setTransferStatus(KylinTableStatusConst.ORDER_TRANSFER_STATUS0);
        orderTicketStatus.setStatus(KylinTableStatusConst.ORDER_STATUS0);
        orderTicketStatus.setIsStudent(isStudent);
        orderTicketStatus.setPayStatus(KylinTableStatusConst.ORDER_PAY_STATUS0);
        orderTicketStatus.setCreatedAt(now);
        orderTicketStatus.setUpdatedAt(null);
        sqls.add(SqlMapping.get("kylin_order_ticket_status.add"));
        LinkedList<Object[]> sqlsDataB = ObjectUtil.cloneLinkedListObj();
        sqlsDataB.add(orderTicketStatus.getAddObject());

        //生成订单 order_ticket_relation
        KylinOrderTicketRelations orderTicketRelations = KylinOrderTicketRelations.getNew();
        String orderTicketRelationId = IDGenerator.nextSnowId();
        orderTicketRelations.setOrderTicketRelationsId(orderTicketRelationId);
        orderTicketRelations.setOrderId(orderTicketId);
        orderTicketRelations.setTransferId("");
        orderTicketRelations.setLiveId("");
        orderTicketRelations.setAgentId(payOrderParam.getAgentId());
        orderTicketRelations.setIsMember(isMember ? 1 : 0);
        orderTicketRelations.setPerformanceId(payOrderParam.getPerformanceId());
        orderTicketRelations.setTimeId(payOrderParam.getTimeId());
        orderTicketRelations.setTicketId(payOrderParam.getTicketId());
        orderTicketRelations.setCreatedAt(now);
        orderTicketRelations.setUpdatedAt(null);
        sqls.add(SqlMapping.get("kylin_order_ticket_relation.add"));
        LinkedList<Object[]> sqlsDataC = ObjectUtil.cloneLinkedListObj();
        sqlsDataC.add(orderTicketRelations.getAddObject());


        //生成票
        KylinOrderTicketEntities orderTicketEntities = KylinOrderTicketEntities.getNew();
        LinkedList<Object[]> sqlsDataD = ObjectUtil.cloneLinkedListObj();
        sqls.add(SqlMapping.get("kylin_order_ticket_entities.add"));
        if (isTrueName == 1) {
            for (AdamEntersVo enters : entersVoList) {
                String orderTicketEntitiesId = IDGenerator.nextSnowId();
                orderTicketEntities.setOrderTicketEntitiesId(orderTicketEntitiesId);
                orderTicketEntities.setOrderId(orderTicketId);
                orderTicketEntities.setTicketId(payOrderParam.getTicketId());
                orderTicketEntities.setUserId(uid);
                orderTicketEntities.setPerformanceId(payOrderParam.getPerformanceId());
                orderTicketEntities.setTimeId(payOrderParam.getTimeId());
                orderTicketEntities.setEnterType(enters.getType());
                orderTicketEntities.setEnterName(enters.getName());
                orderTicketEntities.setEnterMobile(enters.getMobile());
                orderTicketEntities.setEnterIdCode(enters.getIdCard());
                orderTicketEntities.setStatus(KylinTableStatusConst.ENTITIES_STATUS0);
                orderTicketEntities.setSysDamai(ticketData.getSysDamai());
                orderTicketEntities.setCheckClient("");
                orderTicketEntities.setIsPayment(KylinTableStatusConst.ENTITIES_IS_PAYMENT0);
                orderTicketEntities.setRefundPrice(BigDecimal.valueOf(0.0));
                orderTicketEntities.setComment("");
                orderTicketEntities.setCreatedAt(now);
                orderTicketEntities.setUpdatedAt(null);
                sqlsDataD.add(orderTicketEntities.getAddObject());
                // 生成vo
                KylinOrderTicketEntitiesVo orderTicketEntitiesVo = KylinOrderTicketEntitiesVo.getNew();
                BeanUtils.copyProperties(orderTicketEntities, orderTicketEntitiesVo);
                orderTicketEntitiesVo.setPerformanceTitle(performanceData.getTitle());
                orderTicketEntitiesVo.setTicketTitle(ticketData.getTitle());
                orderTicketEntitiesVo.setUseStart(ticketData.getUseStart());
                orderTicketEntitiesVo.setUseEnd(ticketData.getUseEnd());
//                orderTicketEntitiesVo.setTicketsmId(ticketData.getMid());
//                orderTicketEntitiesVo.setTimemId(ticketTimesData.getMid());
                orderTicketEntitiesVo.setCreatedAt(orderTicketEntities.getCreatedAt().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                orderTicketEntitiesVo.setUpdatedAt(null);
                orderTicketEntitiesVo.setChangeDate(orderTicketEntities.getCreatedAt());
                currentTime = System.currentTimeMillis();
                mongoTemplate.insert(orderTicketEntitiesVo, KylinOrderTicketEntitiesVo.class.getSimpleName());
                currentTime = System.currentTimeMillis() - currentTime;
                log.debug("mongo 添加入场人 -> time:" + (currentTime) + "毫秒");
                currentTime = System.currentTimeMillis();
                dataUtils.changeBuyInfo(orderTicketEntitiesVo.getUserId(), orderTicketEntitiesVo.getEnterIdCode(), orderTicketEntitiesVo.getPerformanceId(), orderTicketEntitiesVo.getTicketId(), 1);
                currentTime = System.currentTimeMillis() - currentTime;
                log.debug("redis 修改 限购 -> time:" + (currentTime) + "毫秒");
            }
        } else {
            for (int i = 0; i < payOrderParam.getNumber(); i++) {
                String orderTicketEntitiesId = IDGenerator.nextSnowId().toString();
                orderTicketEntities.setOrderTicketEntitiesId(orderTicketEntitiesId);
                orderTicketEntities.setOrderId(orderTicketId);
                orderTicketEntities.setTicketId(payOrderParam.getTicketId());
                orderTicketEntities.setUserId(uid);
                orderTicketEntities.setPerformanceId(payOrderParam.getPerformanceId());
                orderTicketEntities.setTimeId(payOrderParam.getTimeId());
                orderTicketEntities.setEnterType(0);
                orderTicketEntities.setEnterName("");
                orderTicketEntities.setEnterMobile("");
                orderTicketEntities.setEnterIdCode("");
                orderTicketEntities.setStatus(KylinTableStatusConst.ENTITIES_STATUS0);
                orderTicketEntities.setSysDamai(ticketData.getSysDamai());
                orderTicketEntities.setCheckClient("");
                orderTicketEntities.setIsPayment(KylinTableStatusConst.ENTITIES_IS_PAYMENT0);
                orderTicketEntities.setComment("");
                orderTicketEntities.setCreatedAt(now);
                orderTicketEntities.setUpdatedAt(null);
                sqlsDataD.add(orderTicketEntities.getAddObject());
                // 生成vo
                KylinOrderTicketEntitiesVo orderTicketEntitiesVo = KylinOrderTicketEntitiesVo.getNew();
                BeanUtils.copyProperties(orderTicketEntities, orderTicketEntitiesVo);
                orderTicketEntitiesVo.setPerformanceTitle(performanceData.getTitle());
                orderTicketEntitiesVo.setTicketTitle(ticketData.getTitle());
                orderTicketEntitiesVo.setUseStart(ticketData.getUseStart());
                orderTicketEntitiesVo.setUseEnd(ticketData.getUseEnd());
//                orderTicketEntitiesVo.setTicketsmId(ticketData.getMid());
//                orderTicketEntitiesVo.setTimemId(ticketTimesData.getMid());
                orderTicketEntitiesVo.setCreatedAt(orderTicketEntities.getCreatedAt().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                orderTicketEntitiesVo.setUpdatedAt(null);
                orderTicketEntitiesVo.setChangeDate(orderTicketEntities.getCreatedAt());
                currentTime = System.currentTimeMillis();
                mongoTemplate.insert(orderTicketEntitiesVo, KylinOrderTicketEntitiesVo.class.getSimpleName());
                currentTime = System.currentTimeMillis() - currentTime;
                log.debug("mongo 添加入场人 -> time:" + (currentTime) + "毫秒");
                currentTime = System.currentTimeMillis();
                dataUtils.changeBuyInfo(orderTicketEntitiesVo.getUserId(), orderTicketEntitiesVo.getEnterIdCode(), orderTicketEntitiesVo.getPerformanceId(), orderTicketEntitiesVo.getTicketId(), 1);
                currentTime = System.currentTimeMillis() - currentTime;
                log.debug("redis 修改限购 -> time:" + (currentTime) + "毫秒");
            }
        }

        //是否免费
        boolean isFree = false;
        PayResultVo payResultVo;

        if (orderTickets.getPriceActual().compareTo(BigDecimal.valueOf(0)) > 0) {
            // 调用支付
            String time1 = DateUtil.format(DateUtil.Formatter.yyyyMMddHHmmss.parse(ticketData.getUseStart()), DateUtil.Formatter.MM_dd_zh);
            String time2 = DateUtil.format(DateUtil.Formatter.yyyyMMddHHmmss.parse(ticketData.getUseEnd()), DateUtil.Formatter.MM_dd_zh);
            String useTime = ticketData.getType() == 2 ? time1 + "~" + time2 : time2;
            LinkedMultiValueMap<String, String> httpData = ObjectUtil.cloneLinkedMultiValueMapStringAndString();
            httpData.add("type", "TICKET");
            httpData.add("price", orderTickets.getPriceActual().toString());
            httpData.add("name", useTime + ticketData.getTitle() + "-" + performanceData.getTitle());
            httpData.add("detail", performanceData.getTitle() + "-" + ticketData.getTitle() + "-" + useTime);
            httpData.add("orderCode", orderTickets.getOrderCode());
            httpData.add("clientIp", CurrentUtil.getCliIpAddr());
            httpData.add("notifyUrl", synUrl);
            httpData.add("createDate", orderTickets.getCreatedAt().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
            httpData.add("expireTime", (orderTickets.getPayCountdownMinute()) + "");
            httpData.add("payType", payOrderParam.getPayType());
            httpData.add("deviceFrom", payOrderParam.getDeviceFrom());
            if (payOrderParam.getDeviceFrom().equals("js") || payOrderParam.getDeviceFrom().equals("applet")) {
                httpData.add("openId", payOrderParam.getOpenId());
            }
            if (payOrderParam.getPayType().equals("alipay") && payOrderParam.getDeviceFrom().equals("wap")) {
                httpData.add("showUrl", payOrderParam.getShowUrl() + orderTicketId);
                httpData.add("returnUrl", payOrderParam.getReturnUrl() + orderTicketId);
            }
            currentTime = System.currentTimeMillis();
            String returnData = HttpUtil.post(payUrl, httpData);
            currentTime = System.currentTimeMillis() - currentTime;
            log.info("调用 DRAGON 支付 -> time:" + (currentTime) + "毫秒");
            log.info("调用 DRAGON 结果 = " + returnData);
            payResultVo = JsonUtils.fromJson(returnData, PayResultVo.class);
            payResultVo.getData().setOrderId(orderTicketId);
            payResultVo.getData().setPrice(orderTickets.getPriceActual());
            orderTickets.setPayCode(payResultVo.getData().getCode());
            if (payOrderParam.getPayType().equals("alipay") && payOrderParam.getDeviceFrom().equals("wap")) {
                payResultVo.getData().setShowUrl(payOrderParam.getShowUrl() + orderTicketId);
                payResultVo.getData().setReturnUrl(payOrderParam.getReturnUrl() + orderTicketId);
            }
        } else {
            isFree = true;
            orderTickets.setPayType("FREE");
            orderTickets.setPayCode("FREE_PAY_CODE");
            payResultVo = PayResultVo.getNew();
            PayInnerResultVo payInnerResultVo = PayInnerResultVo.getNew();
            payInnerResultVo.setPrice(BigDecimal.valueOf(0));
            payInnerResultVo.setOrderId(orderTickets.getOrderTicketsId());
            payResultVo.setData(payInnerResultVo);
        }

        sqls.add(SqlMapping.get("kylin_order_ticket.add"));
        LinkedList<Object[]> sqlsDataA = ObjectUtil.cloneLinkedListObj();
        sqlsDataA.add(orderTickets.getAddObject());
        // 生成vo
        KylinOrderTicketVo orderTicketVo = KylinOrderTicketVo.getNew();
        orderTicketVo.setOrderTicket(orderTickets);
        orderTicketVo.setOrderTicketStatus(orderTicketStatus);
        orderTicketVo.setOrderTicketRelation(orderTicketRelations);
        orderTicketVo.setPerformanceImg(performanceData.getImgPoster());
        orderTicketVo.setTicketTitle(ticketData.getTitle());
        orderTicketVo.setUseStart(ticketData.getUseStart());
        orderTicketVo.setTimeStart(performanceData.getTimeStart());
        orderTicketVo.setOverdueAt(orderTickets.getCreatedAt().plusMinutes(performanceData.getPayCountdownMinute()).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        orderTicketVo.setCreatedAt(orderTickets.getCreatedAt().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        orderTicketVo.setChangeDate(orderTickets.getCreatedAt());
        currentTime = System.currentTimeMillis();
        mongoTemplate.insert(orderTicketVo, KylinOrderTicketVo.class.getSimpleName());
        currentTime = System.currentTimeMillis() - currentTime;
        log.debug("mongo  添加 订单 -> time:" + (currentTime) + "毫秒");

        currentTime = System.currentTimeMillis();
        orderUtils.resetOrderListVo(uid, 1, orderTicketVo.getOrderTicketsId(), orderTicketVo);
        currentTime = System.currentTimeMillis() - currentTime;
        log.debug("redis 修改订单列表 -> time:" + (currentTime) + "毫秒");

        // 执行sql
        String sqlData = SqlMapping.gets(sqls, sqlsDataB, sqlsDataC, sqlsDataD, sqlsDataA);
        currentTime = System.currentTimeMillis();
        queueUtils.sendMsgByRedis(MQConst.KylinQueue.SQL_ORDER_CREATE.getKey(),
                sqlData);
        currentTime = System.currentTimeMillis() - currentTime;
        log.debug("MQ 发送 -> time:" + (currentTime) + "毫秒");
        log.info(UserPathDto.setData("下单(唤起支付)", payOrderParam, payResultVo.getData()));
        if (isFree) {
            SyncOrderParam syncOrderParam = SyncOrderParam.getNew();
            syncOrderParam.setOrderCode(orderTickets.getOrderCode());
            syncOrderParam.setPaymentAt(DateUtil.format(LocalDateTime.now(), DateUtil.Formatter.yyyyMMddHHmmss));
            syncOrderParam.setCode(orderTickets.getPayCode());
            syncOrderParam.setPrice(orderTickets.getPrice());
            syncOrderParam.setPaymentId("FREE_PAYMENT_ID");
            syncOrderParam.setPaymentType(orderTickets.getPaymentType());
            syncOrderParam.setStatus(1);
            syncOrder(syncOrderParam);
            return ResponseDto.success(payResultVo.getData());
        } else {
            return ResponseDto.success(payResultVo.getData());
        }
    }

    @Override
    public ResponseDto<PayInnerResultVo> payAgain(PayAgainParam payAgainParam) {
        try {
            String uid = CurrentUtil.getCurrentUid();
            //检查订单时间 是否关闭
            KylinOrderTicketVo orderTicketData = dataUtils.getOrderTicketVo(payAgainParam.getOrderId());
            if (!orderTicketData.getUserId().equals(uid)) {
                return ResponseDto.failure(ErrorMapping.get("20003"));
            }
            if (orderTicketData == null) {
                return ResponseDto.failure(ErrorMapping.get("20024"));
            }

            if (orderTicketData.getStatus() == KylinTableStatusConst.ORDER_STATUS1) {
                return ResponseDto.failure(ErrorMapping.get("20025"));
            } else {
                if (orderTicketData.getStatus() != KylinTableStatusConst.ORDER_STATUS0) {
                    return ResponseDto.failure(ErrorMapping.get("20026"));
                }
            }
            String returnCheckData = HttpUtil.get(checkUrl + "?code=" + orderTicketData.getPayCode(), null);
            PayResultVo checkVo = JsonUtils.fromJson(returnCheckData, PayResultVo.class);
            if (checkVo.getData().getStatus() == 1) {
                return ResponseDto.failure(ErrorMapping.get("20027"));
            }
            if (!orderTicketData.getPayType().equals("no")) {

                if (orderTicketData.getEntitiesVoList().size() == 0) {
                    return ResponseDto.failure(ErrorMapping.get("20004"));
                }
                KylinOrderTicketEntitiesVo entitiesData = orderTicketData.getEntitiesVoList().get(0);

                LinkedMultiValueMap<String, String> httpData = ObjectUtil.cloneLinkedMultiValueMapStringAndString();
                httpData.add("type", "TICKET");
                httpData.add("price", orderTicketData.getPriceActual().toString());
                httpData.add("name", entitiesData.getUseStart() + "" + entitiesData.getPerformanceTitle());
                httpData.add("detail", entitiesData.getPerformanceTitle() + "-" + entitiesData.getTicketTitle() + "-" + entitiesData.getUseStart());
                httpData.add("orderCode", orderTicketData.getOrderCode());
                httpData.add("clientIp", CurrentUtil.getCliIpAddr());
                httpData.add("notifyUrl", synUrl);
                httpData.add("createDate", orderTicketData.getCreatedAt());
                httpData.add("expireTime", orderTicketData.getPayCountdownMinute().toString());

                httpData.add("payType", payAgainParam.getPayType());
                httpData.add("deviceFrom", payAgainParam.getDeviceFrom());

                if (payAgainParam.getDeviceFrom().equals("js") || payAgainParam.getDeviceFrom().equals("applet")) {
                    httpData.add("openId", payAgainParam.getOpenId());
                }

                if (payAgainParam.getPayType().equals("alipay") && payAgainParam.getDeviceFrom().equals("wap")) {
                    httpData.add("showUrl", payAgainParam.getShowUrl() + payAgainParam.getOrderId());
                    httpData.add("returnUrl", payAgainParam.getReturnUrl() + payAgainParam.getOrderId());
                }

                String returnData = HttpUtil.post(payUrl, httpData);
                PayResultVo payResultVo = JsonUtils.fromJson(returnData, PayResultVo.class);
                payResultVo.getData().setOrderId(orderTicketData.getOrderTicketsId());
                payResultVo.getData().setPrice(orderTicketData.getPriceActual());
                if (payAgainParam.getPayType().equals("alipay") && payAgainParam.getDeviceFrom().equals("wap")) {
                    payResultVo.getData().setShowUrl(payAgainParam.getShowUrl());
                    payResultVo.getData().setReturnUrl(payAgainParam.getReturnUrl());
                }

                KylinOrderTickets orderTickets = KylinOrderTickets.getNew();
                orderTickets.setOrderTicketsId(payAgainParam.getOrderId());
                orderTickets.setUpdatedAt(LocalDateTime.now());
                orderTickets.setPayCode(payResultVo.getData().getCode());
                orderTickets.setPayType(payAgainParam.getPayType());

                //改vo
                HashMap<String, Object> map = ObjectUtil.cloneHashMapStringAndObject();
                map.put("payType", payAgainParam.getPayType());
                map.put("payCode", payResultVo.getData().getCode());
                map.put("updatedAt", DateUtil.Formatter.yyyyMMddHHmmss.format(orderTickets.getUpdatedAt()));
                map.put("changeDate", orderTickets.getUpdatedAt());
                mongoTemplate.getCollection(KylinOrderTicketVo.class.getSimpleName()).updateOne(
                        Query.query(Criteria.where("orderTicketsId").is(payAgainParam.getOrderId())).getQueryObject(),
                        ObjectUtil.cloneBasicDBObject().append("$set", mongoConverter.convertToMongoType(map))
                );

                LocalDateTime strTime = LocalDateTime.now();
                dataUtils.delOrderTicketRedis(orderTickets.getOrderTicketsId());

                LinkedList<String> sqls = ObjectUtil.cloneLinkedListStr();
                sqls.add(SqlMapping.get("kylin_order_ticket.payAgain"));
                LinkedList<Object[]> sqlsDataA = ObjectUtil.cloneLinkedListObj();
                sqlsDataA.add(orderTickets.getPayAgainObject(strTime, strTime));
                sqls.add(SqlMapping.get("kylin_order_ticket_status.payAgain"));
                LinkedList<Object[]> sqlsDataB = ObjectUtil.cloneLinkedListObj();
                Object[] objectB = ObjectUtil.cloneObjectsArray(4);
                objectB[0] = orderTickets.getUpdatedAt();
                objectB[1] = orderTickets.getOrderTicketsId();
                objectB[2] = strTime;
                objectB[3] = strTime;
                sqlsDataB.add(objectB);
                sqls.add(SqlMapping.get("kylin_order_ticket_relation.payAgain"));
                LinkedList<Object[]> sqlsDataC = ObjectUtil.cloneLinkedListObj();
                Object[] objectC = ObjectUtil.cloneObjectsArray(4);
                objectC[0] = orderTickets.getUpdatedAt();
                objectC[1] = orderTickets.getOrderTicketsId();
                objectC[2] = strTime;
                objectC[3] = strTime;
                sqlsDataC.add(objectC);
                sqls.add(SqlMapping.get("kylin_order_ticket_entities.payAgain"));
                LinkedList<Object[]> sqlsDataD = ObjectUtil.cloneLinkedListObj();
                Object[] objectD = ObjectUtil.cloneObjectsArray(4);
                objectD[0] = orderTickets.getUpdatedAt();
                objectD[1] = orderTickets.getOrderTicketsId();
                objectD[2] = strTime;
                objectD[3] = strTime;
                sqlsDataD.add(objectD);

                String sqlData = SqlMapping.gets(sqls, sqlsDataA, sqlsDataB, sqlsDataC, sqlsDataD);
                queueUtils.sendMsgByRedis(MQConst.KylinQueue.SQL_ORDER_AGAIN.getKey(), sqlData);
                log.info(UserPathDto.setData("再次支付", payAgainParam, payResultVo.getData()));
                return ResponseDto.success(payResultVo.getData());
            }
            return ResponseDto.failure(ErrorMapping.get("20029"));
        } catch (Exception e) {
            return ResponseDto.failure(ErrorMapping.get("20028"));
        }

    }

    @Override
    public String syncOrder(SyncOrderParam syncOrderParam) {
        try {
            log.debug("SYNC PARAM = " + syncOrderParam.toString());
            //支付时间
            LocalDateTime now = LocalDateTime.now();
            String lock = "order_lock:" + syncOrderParam.getOrderCode();
//            if (!redisLockUtil.tryLock(lock, 1, 5)) {
//                log.error("参数错误");
//                return "fail";//参数错误
//            }

            String timePay = syncOrderParam.getPaymentAt();
            KylinOrderTicketVo orderTicketData = mongoTemplate.findOne(Query.query(Criteria.where("orderCode").is(syncOrderParam.getOrderCode())), KylinOrderTicketVo.class, KylinOrderTicketVo.class.getSimpleName());
            if (orderTicketData == null) {
                log.error("订单不存在");
                return "fail";//订单不存在
            }

            if (orderTicketData.getStatus() != KylinTableStatusConst.ORDER_STATUS0) {
                if (orderTicketData.getPayCode().equals(syncOrderParam.getCode()) && orderTicketData.getStatus() == KylinTableStatusConst.ORDER_STATUS1) {
                    log.error("已经支付");
                    return "success";//已经支付
                }

                if (!orderTicketData.getPayCode().equals(syncOrderParam.getCode())) {
                    log.error("重复支付");
                    return "fail";//重复支付
                }
            }

            if (orderTicketData.getPriceActual().compareTo(syncOrderParam.getPrice()) != 0) {
                log.error("价格不符");
                return "fail";//价格不符
            }

            LinkedList<String> sqls = ObjectUtil.cloneLinkedListStr();
            LinkedList<Object[]> sqlsDataA = ObjectUtil.cloneLinkedListObj();
            LinkedList<Object[]> sqlsDataB = ObjectUtil.cloneLinkedListObj();
            LinkedList<Object[]> sqlsDataC = ObjectUtil.cloneLinkedListObj();
            LinkedList<Object[]> sqlsDataD = ObjectUtil.cloneLinkedListObj();

            LocalDateTime strTime = LocalDateTime.now();

            KylinOrderTickets orderTickets = KylinOrderTickets.getNew();
            KylinOrderTicketStatus orderTicketStatus = KylinOrderTicketStatus.getNew();
            KylinOrderTicketEntities orderTicketEntities = KylinOrderTicketEntities.getNew();

            if (orderTicketData.getStatus() == 2 && syncOrderParam.getStatus().equals(1)) {
                orderUtils.resetOrderListVo(orderTicketData.getUserId(), 2, orderTicketData.getOrderTicketsId(), null);
                log.error("订单号为 {} 的订单超时支付", syncOrderParam.getOrderCode());
                orderRefundsCallbackService.refundApply(orderTicketData.getOrderTicketsId(), syncOrderParam.getPaymentId(), syncOrderParam.getPaymentType());
            } else if ((orderTicketData.getStatus() == 3 || orderTicketData.getStatus() == 4) && syncOrderParam.getStatus().equals(1)) {
                log.error("订单号为 {} 的订单正在退款 或者已退款", syncOrderParam.getOrderCode());
            } else if (syncOrderParam.getStatus().equals(1)) {
                log.error("订单号为 {} 的订单正常流程", syncOrderParam.getOrderCode());
                orderTickets.setOrderTicketsId(orderTicketData.getOrderTicketsId());
                orderTickets.setPaymentType(syncOrderParam.getPaymentType());
                orderTickets.setPayCode(syncOrderParam.getCode());
                orderTickets.setTimePay(timePay);
                orderTickets.setQrCode(IDGenerator.ticketQrCode(orderTicketData.getOrderTicketsId()));
                orderTickets.setUpdatedAt(now);
                orderTickets.setPaymentId(syncOrderParam.getPaymentId());
                sqls.add(SqlMapping.get("kylin_order_ticket.synPay"));
                sqlsDataA.add(orderTickets.getSynOrderObject(strTime, strTime));

                orderTicketStatus.setOrderId(orderTicketData.getOrderTicketsId());
                orderTicketStatus.setStatus(KylinTableStatusConst.ORDER_STATUS1);
                orderTicketStatus.setPayStatus(syncOrderParam.getStatus());
                orderTicketStatus.setUpdatedAt(orderTickets.getUpdatedAt());
                sqls.add(SqlMapping.get("kylin_order_ticket_status.synPay"));
                sqlsDataB.add(orderTicketStatus.getSynOrderObject(strTime, strTime));

                sqls.add(SqlMapping.get("kylin_order_ticket_relation.synPay"));
                Object[] objectC = ObjectUtil.cloneObjectsArray(4);
                objectC[0] = orderTickets.getUpdatedAt();
                objectC[1] = orderTickets.getOrderTicketsId();
                objectC[2] = strTime;
                objectC[3] = strTime;
                sqlsDataC.add(objectC);

                orderTicketEntities.setOrderId(orderTicketData.getOrderTicketsId());
                orderTicketEntities.setIsPayment(KylinTableStatusConst.ENTITIES_IS_PAYMENT1);
                orderTicketEntities.setUpdatedAt(orderTickets.getUpdatedAt());
                sqls.add(SqlMapping.get("kylin_order_ticket_entities.synPay"));
                sqlsDataD.add(orderTicketEntities.getSynOrderObject(strTime, strTime));

                //vo
                HashMap<String, Object> orderTicketVo = ObjectUtil.cloneHashMapStringAndObject();
                orderTicketVo.put("paymentType", orderTickets.getPaymentType());
                orderTicketVo.put("payCode", orderTickets.getPayCode());
                orderTicketVo.put("timePay", orderTickets.getTimePay());
                orderTicketVo.put("qrCode", orderTickets.getQrCode());
                orderTicketVo.put("status", KylinTableStatusConst.ORDER_STATUS1);
                orderTicketVo.put("payStatus", orderTicketStatus.getStatus());
                orderTicketVo.put("updatedAt", timePay);
                orderTicketVo.put("changeDate", now);
                mongoTemplate.getCollection(KylinOrderTicketVo.class.getSimpleName()).updateOne(
                        Query.query(Criteria.where("orderTicketsId").is(orderTickets.getOrderTicketsId())).getQueryObject(),
                        ObjectUtil.cloneBasicDBObject().append("$set", mongoConverter.convertToMongoType(orderTicketVo))
                );


                HashMap<String, Object> orderTicketEntitiesVo = ObjectUtil.cloneHashMapStringAndObject();
                orderTicketEntitiesVo.put("isPayment", KylinTableStatusConst.ENTITIES_IS_PAYMENT1);
                orderTicketEntitiesVo.put("updatedAt", timePay);
                orderTicketEntitiesVo.put("changeDate", now);
                mongoTemplate.getCollection(KylinOrderTicketEntitiesVo.class.getSimpleName()).updateMany(
                        Query.query(Criteria.where("orderId").is(orderTicketData.getOrderTicketsId())).getQueryObject(),
                        ObjectUtil.cloneBasicDBObject().append("$set", mongoConverter.convertToMongoType(orderTicketEntitiesVo))
                );

                queueUtils.sendMsgByRedis(MQConst.KylinQueue.SQL_ORDER_PAY.getKey(),
                        SqlMapping.gets(sqls, sqlsDataA, sqlsDataB, sqlsDataC, sqlsDataD));

                //生成vo redis
                dataUtils.delOrderTicketRedis(orderTickets.getOrderTicketsId());
                orderUtils.resetOrderListVo(orderTicketData.getUserId(), 2, orderTicketData.getOrderTicketsId(), null);

                // 发短信
                KylinPerformanceVo performanceData = dataUtils.getPerformanceVo(orderTicketData.getPerformanceId());
                KylinTicketTimesVo ticketTimesData = null;
                KylinTicketVo ticketData = null;
                for (int x = 0; x < performanceData.getTicketTimeList().size(); x++) {
                    KylinTicketTimesVo timeItem = performanceData.getTicketTimeList().get(x);
                    if (timeItem.getTimeId().equals(orderTicketData.getTimeId())) {
                        ticketTimesData = timeItem;
                        for (int y = 0; y < ticketTimesData.getTicketList().size(); y++) {
                            KylinTicketVo ticketItem = ticketTimesData.getTicketList().get(y);
                            if (ticketItem.getTicketsId().equals(orderTicketData.getTicketId())) {
                                ticketData = ticketItem;
                                break;
                            }
                        }
                        break;
                    }
                }

                String time1 = DateUtil.format(DateUtil.Formatter.yyyyMMddHHmmss.parse(ticketData.getUseStart()), DateUtil.Formatter.yyyy_MM_dd);
                String time2 = DateUtil.format(DateUtil.Formatter.yyyyMMddHHmmss.parse(performanceData.getTimeStart()), DateUtil.Formatter.HHmm);

                SmsEnum.ADTemplate adTemplate = null;
                if (orderTicketData.getGetTicketType().equals("express")) {
                    adTemplate = SmsEnum.ADTemplate.SMS_223203737;
                } else if (orderTicketData.getGetTicketType().equals("electronic")) {
                    adTemplate = ticketData.getIsShowCode() == 1 ? SmsEnum.ADTemplate.SMS_223203737 : SmsEnum.ADTemplate.SMS_223203737;
                }

                if (null != adTemplate) {
                    queueUtils.sendMsgByRedis(MQConst.KylinQueue.SMS_NOTICE.getKey(),
                            SmsMessage.builder().setPhone(orderTicketData.getUserMobile())
                                    .setSignName(SmsEnum.ADSignName.M02.getVal())
                                    .setTemplateCode(adTemplate.name())
                                    .setTemplateParam("name", orderTicketData.getPerformanceTitle())
                                    .setTemplateParam("time", time1 + " " + time2).toJson()
                    );
                }

                // 大麦回调
//                sycDamaiOrder(orderTickets.getOrderTicketsId(), orderTicketData.getIsMember());
            }
            log.info(UserPathDto.setData("订单支付成功回调", syncOrderParam, ""));
            return "success";
        } catch (Exception e) {
            log.error("SYNCE ORDER E = ", e);
            e.printStackTrace();
            return "fail";
        }
    }

    @Override
    public ResponseDto<Integer> checkOrderResult(String orderId) {
        String uid = CurrentUtil.getCurrentUid();
        KylinOrderTicketVo orderTicketData = dataUtils.getOrderTicketVo(orderId);
        if (!orderTicketData.getUserId().equals(uid)) {
            return null;
        }
        if (orderTicketData == null) {
            return ResponseDto.failure(ErrorMapping.get("20024"));
        } else {
            String returnCheckData = HttpUtil.get(checkUrl + "?code=" + orderTicketData.getPayCode(), null);
            SyncOrderDtoParam syncOrderDtoParam = JsonUtils.fromJson(returnCheckData, SyncOrderDtoParam.class);
            if (syncOrderDtoParam.getData().getStatus() == 1) {
                //处理订单
                syncOrder(syncOrderDtoParam.getData());
                return ResponseDto.success(1);
            } else {
                return ResponseDto.success(0);
            }
        }
    }

    public boolean checkAgent(String agentId, KylinTicketVo ticketData) {
        if (agentId.equals(0)) {
            return true;
        } else {
            boolean isAgent = ticketData.getIsAgent() == 1;
            if (isAgent) {
                return true;
            } else {
                return !redisUtil.getDB15RedisHasKey(KylinRedisConst.AGENT, agentId);
            }
        }
//        boolean isAgent = ticketData.getIsAgent() == 1;
//        if (isAgent) {
//            return redisUtil.getDB15RedisHasKey(KylinRedisConst.AGENT, agentId);
//        } else {
//            return true;
//        }
    }

    private boolean sycDamaiOrder(String orderId, int isMember) {
        try {
            KylinOrderTicketVo orderData = dataUtils.getOrderTicketVo(orderId);
            KylinPerformanceVo vo = dataUtils.getPerformanceVo(orderData.getPerformanceId());
            TaobaoClient client = taobaoTicketUtils.initTaobaoClient();
            int isSysDamai = 0;
            for (int x = 0; x < vo.getTicketTimeList().size(); x++) {
                KylinTicketTimesVo timeItem = vo.getTicketTimeList().get(x);
                for (int y = 0; y < timeItem.getTicketList().size(); y++) {
                    KylinTicketVo ticketItem = timeItem.getTicketList().get(y);
                    if (ticketItem.getTicketsId().equals(orderData.getTicketId())) {
                        isSysDamai = ticketItem.getSysDamai();
                        break;
                    }
                }
            }
            if (isSysDamai == 1) {
                KylinOrderTicketVo orderVo = dataUtils.getOrderTicketVo(orderId);
                List<KylinOrderTicketEntitiesVo> listData = orderVo.getEntitiesVoList();
                AlibabaDamaiMevOpenBatchpushticketRequest req = new AlibabaDamaiMevOpenBatchpushticketRequest();
                List<AlibabaDamaiMevOpenBatchpushticketRequest.ThirdTicketPushOpenParam> list2 = new ArrayList<>();
                for (int i = 0; i < listData.size(); i++) {
                    KylinOrderTicketEntitiesVo item = listData.get(i);
                    AlibabaDamaiMevOpenBatchpushticketRequest.ThirdTicketPushOpenParam obj3 = new AlibabaDamaiMevOpenBatchpushticketRequest.ThirdTicketPushOpenParam();
                    obj3.setUserName(item.getEnterName());//用户名 入场人姓名
                    obj3.setCertificateNo(item.getEnterIdCode());//证件号 入场人身份证
                    obj3.setOrderUserMobile(item.getEnterMobile());//用户手机号 入场人手机号
                    obj3.setCertificateType(item.getEnterType().longValue());//证件内容 入场人证件type
                    obj3.setPayTime(DateUtil.parse(orderData.getTimePay(), "yyyy-MM-dd HH:mm:ss"));//支付时间

                    long ticketTimesKey;
                    if (item.getTicketId().length() > 13) {
                        ticketTimesKey = Long.valueOf(item.getTicketId().substring(0, 5).concat(item.getTicketId().substring(7, 12)));
                    } else {
                        ticketTimesKey = Long.parseLong(item.getTicketId());
                    }

                    long ticketIdKey;
                    if (item.getTicketId().length() > 13) {
                        ticketIdKey = Long.valueOf(item.getTicketId().substring(0, 5).concat(item.getTicketId().substring(7, 12)));
                    } else {
                        ticketIdKey = Long.valueOf(item.getTicketId());
                    }

                    long orderIdKey;
                    if (orderData.getOrderTicketsId().length() > 13) {
                        orderIdKey = Long.valueOf(orderData.getOrderTicketsId().substring(0, 5).concat(orderData.getOrderTicketsId().substring(7, 12)));
                    } else {
                        orderIdKey = Long.valueOf(orderData.getOrderTicketsId());
                    }

                    long orderTicketEntitiesKey;
                    if (isMember == 1) {
                        if (item.getOrderTicketEntitiesId().length() > 13) {
                            orderTicketEntitiesKey = Long.valueOf(item.getOrderTicketEntitiesId().substring(0, 5).concat(item.getOrderTicketEntitiesId().substring(7, 12)) + "010");
                        } else {
                            orderTicketEntitiesKey = Long.valueOf(item.getOrderTicketEntitiesId() + "010");//票单号 入场人id
                        }
                    } else {
                        if (item.getOrderTicketEntitiesId().length() > 13) {
                            orderTicketEntitiesKey = Long.valueOf(item.getOrderTicketEntitiesId().substring(0, 5).concat(item.getOrderTicketEntitiesId().substring(7, 12) + "020"));//票单号 入场人id
                        } else {
                            orderTicketEntitiesKey = Long.valueOf(item.getOrderTicketEntitiesId() + "020");//票单号 入场人id
                        }
                    }

                    obj3.setPerformId(ticketTimesKey);//场次id
                    obj3.setTicketItemId(ticketIdKey);
                    obj3.setVoucherId(orderTicketEntitiesKey);//票单号 入场人id

                    obj3.setOrderId(orderIdKey);//订单id orderId
                    obj3.setMediumType(orderData.getGetTicketType().equals("express") ? 1L : 2L);//票类型 快递 电子
                    obj3.setSupplierSecret(taobaoTicketUtils.getSupplierSecret());
                    obj3.setSystemId(taobaoTicketUtils.getSystemId());
                    obj3.setSeatType(1L);
                    obj3.setTicketType(1L);//票类型
                    list2.add(obj3);
                }
                req.setThirdTicketSetOpenParamList(list2);
                if (list2.size() == 0) {
                    log.info("error data = success");
                    return true;
                } else {
                    AlibabaDamaiMevOpenBatchpushticketResponse rsp = client.execute(req);
                    log.info("error data =" + rsp.getBody());
                    return rsp.getResult().getSuccess();
                }
            }
            return true;
        } catch (Exception e) {
            log.info("error data =", e);
            return false;
        }
    }
}
