package com.liquidnet.service.kylin.dto.vo.middle;

import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.kylin.dto.vo.partner.KylinTicketTimesPartnerVo;
import com.liquidnet.service.kylin.entity.KylinTicketTimes;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.format.DateTimeFormatter;
import java.util.List;

@Data
@ApiModel
public class KylinTicketTimesVo {

    private Integer mid;
    @ApiModelProperty(value = "主键")
    private String ticketTimesId;
    @ApiModelProperty(value = "名称")
    private String title;
    @ApiModelProperty(value = "类型 1单日 2通票")
    private Integer type;
    @ApiModelProperty(value = "演出id")
    private String performanceId;
    @ApiModelProperty(value = "场次id")
    private String timeId;
    @ApiModelProperty(value = "适用开始时间")
    private String useStart;
    @ApiModelProperty(value = "适用结束时间")
    private String useEnd;
    @ApiModelProperty(value = "票种")
    private List<KylinTicketVo> ticketList;

    public void setTicketTimes(KylinTicketTimes ticketTimes) {
        this.mid = ticketTimes.getMid();
        this.ticketTimesId = ticketTimes.getTicketTimesId();
        this.title = ticketTimes.getTitle();
        this.type = ticketTimes.getType();
        this.useStart = DateUtil.Formatter.yyyyMMddHHmmss.format(ticketTimes.getUseStart());
        this.useEnd = DateUtil.Formatter.yyyyMMddHHmmss.format(ticketTimes.getUseEnd());
    }

    public void setTicketTimes(KylinTicketTimesPartnerVo ticketTimes) {
        this.ticketTimesId = ticketTimes.getTicketTimesId();
        this.title = ticketTimes.getTitle();
        this.type = ticketTimes.getType();
        this.useStart = ticketTimes.getUseStart();
        this.useEnd = ticketTimes.getUseEnd();
    }
}
