package com.liquidnet.service.kylin.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * <p>
 * 订单快递
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-06-25
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class KylinOrderExpress implements Serializable, Cloneable {

    private static final long serialVersionUID = -2070614388666759280L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Integer mid;

    private String orderExpressId;
    private String orderTicketsId;
    private String performancesId;
    private String orderExpressCode;
    private String mailno;
    private Integer expressType;
    private String filterResult;
    private String remark;
    private Integer expressStatus;
    private String origincode;
    private String destcode;
    private String printIcon;
    private String twoDimensionCode;
    private String printFlag;
    private BigDecimal freightPrice;

    private Integer sendType;
    private Integer sendExpressType;
    private String expressContacts;
    private String expressPhone;
    private String sendExpressAddress;
    private String appointmentTime;

    private String return_tracking_no;
    private String sourceTransferCode;
    private String sourceCityCode;
    private String sourceDeptCode;
    private String sourceTeamCode;
    private String destCityCode;
    private String destDeptCode;
    private String destDeptCodeMapping;
    private String destTeamCode;
    private String destTeamCodeMapping;
    private String destTransferCode;
    private String destRouteLabel;
    private String proName;
    private String cargoTypeCode;
    private String limitTypeCode;
    private String expressTypeCode;
    private String codingMapping;
    private String codingMappingOut;
    private String xbFlag;
    private String proCode;
    private String abFlag;
    private String destPortCode;
    private String destCountry;
    private String destPostCode;
    private String goodsValueTotal;
    private String currencySymbol;
    private String goodsNumber;
    private String twoDimensionCode2;
    private String newIcon;
    private String newAbflag;

    private Integer isPrint;
    private Integer printNum;
    private String orderRefundsId;

    /**
     * 创建时间
     */
    private String createdAt;

    /**
     * 修改时间
     */
    private String updatedAt;

    private static final KylinOrderExpress obj = new KylinOrderExpress();

    public static KylinOrderExpress getNew() {
        try {
            return (KylinOrderExpress) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new KylinOrderExpress();
        }
    }
}
