drop TABLE if exists `kylin_camera`;
CREATE TABLE `kylin_camera`
(
    `mid`          int unsigned NOT NULL AUTO_INCREMENT,
    `camera_id`    varchar(255) NOT NULL DEFAULT '' COMMENT 'camera_id',
    `camera_gb_id` varchar(255) NOT NULL DEFAULT '' COMMENT '国标ID',
    `camera_name`  varchar(255) NOT NULL DEFAULT '' COMMENT '设备ID',
    `field_id`     varchar(64)  NOT NULL DEFAULT '' COMMENT '场地ID',
    `img_url`      varchar(500) NOT NULL DEFAULT '' COMMENT '截图url',
    `site_type`    tinyint      NOT NULL DEFAULT 0 COMMENT '地点类型 1卫生间 2。。。',
    `created_at`   timestamp    NULL     DEFAULT NULL,
    `updated_at`   timestamp    NULL     DEFAULT NULL,
    KEY `idx_camera_id` (`camera_id`),
    PRIMARY KEY (`mid`)
) ENGINE = InnoDB
  DEFAULT CHARSET utf8mb4
  COLLATE utf8mb4_unicode_ci COMMENT '人流量排队检测摄像头表';

drop TABLE if exists `kylin_camera_record`;
CREATE TABLE `kylin_camera_record`
(
    `mid`              int unsigned NOT NULL AUTO_INCREMENT,
    `camera_record_id` varchar(255) NOT NULL DEFAULT '' COMMENT 'camera_record_id',
    `camera_id`        varchar(255) NOT NULL DEFAULT '' COMMENT 'camera_id',
    `person_num`       int          NOT NULL DEFAULT 0 COMMENT '检测到的人数',
    `created_at`       timestamp    NULL     DEFAULT NULL,
    `updated_at`       timestamp    NULL     DEFAULT NULL,
    KEY `idx_camera_record_id` (`camera_record_id`),
    PRIMARY KEY (`mid`)
) ENGINE = InnoDB
  DEFAULT CHARSET utf8mb4
  COLLATE utf8mb4_unicode_ci COMMENT '人流量检测记录表';
