package com.liquidnet.service.platform.controller.kylin;


import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 人流量排队检测摄像头表 前端控制器
 * </p>
 *
 * @author jiangxiulong
 * @since 2022-01-10
 */
@Api(tags = "截图回调")
@Slf4j
@RestController
@RequestMapping("/camera")
public class KylinCameraCallBackController {

    @PostMapping(value = "create", produces = "application/xml;charset=UTF-8")
    @ApiOperation("截图回调")
    public String record(
            @RequestBody String requestBody,
//            @RequestParam() String requestBody,
            @RequestParam(value = "Version", defaultValue = "") String Version,
            @RequestParam(value = "Signature", defaultValue = "") String Signature,
            @RequestParam(value = "SignatureMethod", defaultValue = "") String SignatureMethod,
            @RequestParam(value = "SignatureNonce", defaultValue = "") String SignatureNonce,
            @RequestParam(value = "SignatureVersion", defaultValue = "") String SignatureVersion,
            @RequestParam(value = "AccessKeyId", defaultValue = "") String AccessKeyId,
            @RequestParam(value = "Timestamp", defaultValue = "") String Timestamp
    ) {
        try {
            log.info("\n接收截图回调请求：[Version=[{}], Signature=[{}], [SignatureMethod=[{}], SignatureNonce=[{}], SignatureVersion=[{}],"
                            + " AccessKeyId=[{}], Timestamp=[{}], requestBody=[\n{}\n] ",
                    Version, Signature, SignatureMethod, SignatureNonce, SignatureVersion, AccessKeyId, Timestamp, requestBody);
            // TODO: 2022/1/10 jxltodo 验签
            return "success";
        } catch (Exception e) {
            log.error("截图回调Exception：[msg={}, e={}]", e.getMessage(), e);
            return "error";
        }
    }

}
