package com.liquidnet.client.admin.web.controller.zhengzai.goblin;


import com.alibaba.fastjson.JSON;
import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.zhengzai.goblin.service.impl.GoblinFrontCubeServiceImpl;
import com.liquidnet.service.goblin.entity.GoblinFrontCube;
import com.liquidnet.service.goblin.param.GoblinFrontCubeParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 *  前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2022-01-07
 */
@Api(tags = "魔方管理")
@RestController
@RequestMapping("/goblin-front-cube")
public class GoblinFrontCubeController  extends BaseController {
    @Autowired
    GoblinFrontCubeServiceImpl goblinFrontCubeService;
    /**
     * 获取魔方列表
     */
    @PostMapping("list")
    @ApiOperation(value = "list")
    @ResponseBody
    public AjaxResult list() {
        return AjaxResult.success(goblinFrontCubeService.listGoblinFrontCubeParam());
    }


   /***
     * @author zhangfuxin
     * @Description:  修改或者删除魔方
     * @date 2022/1/7 下午6:30
     */
    @PostMapping("updateOrCreate")
    @ApiOperation(value = "修改或者删除魔方")
    @ResponseBody
    public AjaxResult updateOrCreate(@RequestBody List<GoblinFrontCubeParam> list) {
        List<GoblinFrontCube> list1=new ArrayList<>();
        for(GoblinFrontCubeParam goblinFrontCubeParam:list){
            GoblinFrontCube goblinFrontCube=new GoblinFrontCube();
            BeanUtils.copyProperties(goblinFrontCubeParam,goblinFrontCube);
            list1.add(goblinFrontCube);
        }
        logger.info("修改banner{}", JSON.toJSONString(list));
        boolean result=goblinFrontCubeService.updateOrCreate(list1);
        if (result ) {
            return success("操作成功");
        } else {
            return error("操作失败");
        }
    }
    @PostMapping("delete")
    @ApiOperation(value = "删除魔方")
    @ResponseBody
    public AjaxResult delete( @RequestBody GoblinFrontCubeParam goblinFrontCubeParam) {
        boolean result=goblinFrontCubeService.deleteGoblinFrontCube(goblinFrontCubeParam.getMid());
        if (result ) {
            return success("操作成功");
        } else {
            return error("操作失败");
        }
    }



}
