package com.liquidnet.client.admin.zhengzai.goblin.dto;

import com.liquidnet.client.admin.common.annotation.Excel;
import com.liquidnet.service.goblin.entity.GoblinSelfTag;
import lombok.Data;

import java.io.Serializable;

@Data
public class GoblinSelfExtagExcelDto implements Serializable, Cloneable {
    private static final long serialVersionUID = -8546526848518431986L;
    @Excel(name = "标签名称")
    private String tagName;
    @Excel(name = "标签图片")
    private String tagPic;
    @Excel(name = "标签类型")
    private String tagType;

    private static final GoblinSelfExtagExcelDto obj = new GoblinSelfExtagExcelDto();

    public static GoblinSelfExtagExcelDto getNew() {
        try {
            return (GoblinSelfExtagExcelDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinSelfExtagExcelDto();
        }
    }

    public GoblinSelfExtagExcelDto copy(GoblinSelfTag source) {
        if (null == source) return this;
        this.setTagName(source.getTagName());
        this.setTagPic(source.getTagPic());
        switch (source.getTagType()) {
            case "1":
                this.setTagType("音乐人");
                break;
            case "2":
                this.setTagType("艺术家");
                break;
            case "3":
                this.setTagType("品牌方");
                break;
            case "4":
                this.setTagType("厂牌");
                break;
            default:
                this.setTagType("其它");
                break;
        }
        return this;
    }
}
