package com.liquidnet.service.goblin.controller.manage;

import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.manage.GoblinStoreZhengzaiCommonParam;
import com.liquidnet.service.goblin.dto.vo.GoblinMarketSpuListVo;
import com.liquidnet.service.goblin.dto.vo.GoblinSelfMarketingVo;
import com.liquidnet.service.goblin.dto.vo.GoblinSelfZhengzaiSkuVo;
import com.liquidnet.service.goblin.service.manage.IGoblinZhengzaiService;
import io.swagger.annotations.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

/**
 * 正在下单活动管理
 */
@ApiSupport(order = 149201)
@Slf4j
@RestController
@Api(tags = "活动-正在下单")
@RequestMapping("store/zhengzai")
public class GoblinZhengzaiController {

    @Autowired
    IGoblinZhengzaiService goblinZhengzaiService;

    @GetMapping("list")
    @ApiOperation("活动详情-正在下单-可参与活动列表")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "storeId", value = "商铺id", example = "1")
    })
    public ResponseDto<List<GoblinSelfMarketingVo>> zhengzaiCanJoin(@RequestParam("storeId") @Valid String storeId) {
        return ResponseDto.success(goblinZhengzaiService.zhengzaiCanJoin(storeId));
    }

    @GetMapping("detals")
    @ApiOperation("活动详情-正在下单-可参与活动详情")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "storeId", value = "商铺id", example = "1"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "selfMarketId", value = "官方活动id", example = "1")
    })
    public ResponseDto<GoblinSelfMarketingVo> zhengzaiCanJoinDetails(@RequestParam("storeId") @Valid String storeId,
                                                                     @RequestParam("selfMarketId") @Valid String selfMarketId) {
        return ResponseDto.success(goblinZhengzaiService.zhengzaiCanJoinDetails(selfMarketId, storeId));
    }

    @GetMapping("config/spu")
    @ApiOperation("活动详情-正在下单-获取商铺spu")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "storeId", value = "商铺id", example = "1"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "selfMarketId", value = "官方活动id", example = "1"),
            @ApiImplicitParam(type = "form", required = true, dataType = "Integer", name = "page", value = "页数", example = "1")
    })
    public ResponseDto<List<GoblinMarketSpuListVo>> zhengzaiStoreConfigSpuList(@RequestParam("storeId") @Valid String storeId,
                                                                               @RequestParam("selfMarketId") @Valid String selfMarketId,
                                                                               @RequestParam("page") @Valid int page) {
        return goblinZhengzaiService.zhengzaiSpuList(selfMarketId, storeId, page);
    }

    @GetMapping("config/sku")
    @ApiOperation("活动详情-正在下单-获取商铺sku")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "storeId", value = "商铺id", example = "1"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "selfMarketId", value = "官方活动id", example = "1"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "spuId", value = "spuId", example = "1")
    })
    public ResponseDto<List<GoblinSelfZhengzaiSkuVo>> zhengzaiStoreConfigSkuList(@RequestParam("storeId") @Valid String storeId,
                                                                                 @RequestParam("spuId") @Valid String spuId,
                                                                                 @RequestParam("selfMarketId") @Valid String selfMarketId) {
        return goblinZhengzaiService.zhengzaiSkuList(selfMarketId, storeId, spuId);
    }

    @PostMapping("config/insert")
    @ApiOperation("活动详情-正在下单-添加商铺sku")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<Boolean> zhengzaiStoreInsert(@RequestBody GoblinStoreZhengzaiCommonParam params) {
        return goblinZhengzaiService.zhengzaiSkuInsert(params);
    }

    @PostMapping("config/update")
    @ApiOperation("活动详情-正在下单-修改商铺sku")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<Boolean> zhengzaiStoreUpdate(@RequestBody GoblinStoreZhengzaiCommonParam params) {
        return goblinZhengzaiService.zhengzaiSkuUpdate(params);
    }

    @PostMapping("config/del")
    @ApiOperation("活动详情-正在下单-删除商铺spu")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "storeId", value = "商铺id", example = "1"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "selfMarketId", value = "官方活动id", example = "1"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "spuId", value = "spuId", example = "1"),
    })
    public ResponseDto<Boolean> zhengzaiStoreDel(@RequestParam("storeId") @Valid String storeId,
                                                 @RequestParam("selfMarketId") @Valid String selfMarketId,
                                                 @RequestParam("spuId") @Valid String spuId) {
        return goblinZhengzaiService.zhengzaiSpuDel(selfMarketId, storeId, spuId);
    }
}
