package com.liquidnet.service.bank.currencycloud.service.impl;

import com.liquidnet.service.bank.currencycloud.entity.BankCcPushLog;
import com.liquidnet.service.bank.currencycloud.mapper.BankCcPushLogMapper;
import com.liquidnet.service.bank.currencycloud.service.IBankCcPushLogService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2020-11-04
 */
@Service("bankCcPushLogService")
public class BankCcPushLogServiceImpl implements IBankCcPushLogService {

    @Autowired
    BankCcPushLogMapper bankCcPushLogMapper;

    @Async
    @Override
    public Integer asyncInsert(BankCcPushLog bankCcPushLog) {
        try {
            bankCcPushLog.setCreateTime(LocalDateTime.now());
            return bankCcPushLogMapper.insert(bankCcPushLog);
        } catch (Exception e) {
            return 0;
        }

    }

}
