package com.liquidnet.service.dragon.channel.douyinpay.strategy.impl;

import com.liquidnet.service.dragon.channel.douyinpay.strategy.annotation.StrategyDouYinPayHandler;
import com.liquidnet.service.dragon.channel.wepay.resp.WepayPayRespDto;
import com.liquidnet.service.dragon.channel.wepay.strategy.annotation.StrategyWepayHandler;
import com.liquidnet.service.dragon.channel.wepay.strategy.impl.AbstractWepayStrategy;
import com.liquidnet.service.dragon.constant.DragonConstant;
import com.liquidnet.service.dragon.dto.DragonPayBaseReqDto;
import com.liquidnet.service.dragon.dto.DragonPayBaseRespDto;
import com.liquidnet.service.dragon.utils.PayWepayUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

/**
 * @author zhangfuxin
 * @Description: 抖音小程序支付实现
 * @date 2021/11/9 下午1:45
 */
@Slf4j
@Component
@StrategyDouYinPayHandler(DragonConstant.DeviceFromEnum.APPLET)
public class DouYinPayStrategyAppletImpl extends AbstractDouYinPayStrategy {
    @Value("${liquidnet.dragon.url}")
    private String notifyUrl;

    @Override
    SortedMap<String, Object> appendRequestParam(SortedMap<String, Object> requestMap, DragonPayBaseReqDto dragonPayBaseReqDto) {
        requestMap.put("app_id", PayWepayUtils.getInstance().getAPP_ID());
        return requestMap;
    }

    @Override
    DragonPayBaseRespDto buildResponseDto(DragonPayBaseRespDto payBaseRespDto, Map result) {
        return null;
    }


    @Override
    protected String getRequestUrl() {
        return "https://developer.toutiao.com/api/apps/ecpay/v1/create_order";
    }

    @Override
    protected String getNotifyUrl() {
        return notifyUrl + "/notify/wepay/applet";
    }

    @Override
    protected String getAppid() {
        return PayWepayUtils.getInstance().getAPP_ID();
    }
}
