package com.liquidnet.service.goblin.dto.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 轮播图
 * </p>
 *
 * @author liquidnet
 * @since 2021-12-27
 */
@ApiModel(value = "GoblinFrontBannerBuildParam", description = "轮播图param")
@Data
public class GoblinFrontGoodDetailVo implements Serializable {
    //spu
    GoblinGoodsInfoDetailVo goblinGoodsInfoVo;
    //sku
    List<GoblinGoodsSkuInfoDetailVo> goblinGoodsSkuInfoVolist;
    @ApiModelProperty(value = "商铺名称")
    String storeName;
    @ApiModelProperty(value = "商品可参与券类型")
    ArrayList<String>  getSpuType;

    @ApiModelProperty(value = "条码识别到的SKUID列表", notes = "仅当条码识别时有效")
    private List<String> hitSkuIdList;

    private static final long serialVersionUID = 1L;

    private static final GoblinFrontGoodDetailVo obj = new GoblinFrontGoodDetailVo();

    public static GoblinFrontGoodDetailVo getNew() {
        try {
            return (GoblinFrontGoodDetailVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinFrontGoodDetailVo();
        }
    }

}
