package com.liquidnet.service.goblin.dto.vo;

import com.liquidnet.service.smile.entity.SmileAgent;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * <p>
 * 
 * </p>
 *
 * @author liquidnet
 * @since 2022-03-16
 */
@Data
public class SmileAgentVo implements Serializable, Cloneable{

    private Long id;

    /**
     * 演出id
     */
    private String performanceId;

    /**
     * 票id
     */
    private String ticketId;

    /**
     * 票种
     */
    private String ticketType;

    /**
     * 总代票提
     */
    @ApiModelProperty(value = "总代票提")
    private BigDecimal totalCarry;

    /**
     * 普代票提
     */
    @ApiModelProperty(value = "普代票提")
    private BigDecimal ordCarry;

    private static final SmileAgentVo obj = new SmileAgentVo();
    public static SmileAgentVo getNew() {
        try {
            return (SmileAgentVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new SmileAgentVo();
        }
    }

    public SmileAgentVo copy(SmileAgent smileAgent) {
        if (null == smileAgent) return this;
        this.setId(smileAgent.getId());
        this.setPerformanceId(smileAgent.getPerformanceId());
        this.setTicketId(smileAgent.getTicketId());
        this.setTotalCarry(smileAgent.getTotalCarry());
        this.setOrdCarry(smileAgent.getOrdCarry());
        return this;
    }

}
