package com.liquidnet.commons.lang.util;

import org.apache.commons.lang3.StringUtils;

import java.time.LocalDateTime;

public class IDCardUtil {
    /**
     * 15位身份证号
     */
    private static final int FIFTEEN_ID_CARD = 15;
    /**
     * 18位身份证号
     */
    private static final int EIGHTEEN_ID_CARD = 18;

    /**
     * 根据身份证号获取性别
     *
     * @param idNo
     * @return int [0-未知|1-男|2-女]
     */
    public static int getSexCode(String idNo) {
        int sex = 0;
        if (StringUtils.isNotBlank(idNo)) {
            int sexNum;
            switch (idNo.length()) {
                case FIFTEEN_ID_CARD:
                    sexNum = Integer.parseInt(idNo.substring(14, 15));
                    break;
                case EIGHTEEN_ID_CARD:
                    sexNum = Integer.parseInt(idNo.substring(16).substring(0, 1));
                    break;
                default:
                    return sex;
            }

            if (sexNum % 2 == 0) {// 判断性别
                sex = 2;
            } else {
                sex = 1;
            }
        }
        return sex;
    }

    /**
     * 根据身份证号获取性别
     *
     * @param idNo
     * @return String[""-未知|"女"|"男"]
     */
    public static String getSexStr(String idNo) {
        String sex = "";
        if (StringUtils.isNotBlank(idNo)) {
            int sexNum;
            switch (idNo.length()) {
                case FIFTEEN_ID_CARD:
                    sexNum = Integer.parseInt(idNo.substring(14, 15));
                    break;
                case EIGHTEEN_ID_CARD:
                    sexNum = Integer.parseInt(idNo.substring(16).substring(0, 1));
                    break;
                default:
                    return sex;
            }

            if (sexNum % 2 == 0) {// 判断性别
                sex = "女";
            } else {
                sex = "男";
            }
        }
        return sex;
    }

    /**
     * 根据身份证号获取年龄，精确到天
     *
     * @param idNo
     * @return int
     */
    public static int getAge(String idNo) {
        int age = 0;
        if (StringUtils.isNotBlank(idNo)) {
            LocalDateTime now = LocalDateTime.now();
            int nowYear = now.getYear(), nowMonth = now.getMonthValue(), nowDay = now.getDayOfMonth();// 当前年份、月份

            String uYear, uMonth, uDay;// 身份证年份、月份、天
            switch (idNo.length()) {
                case FIFTEEN_ID_CARD:
                    // 身份证上的年份(15位身份证为1980年前的)
                    uYear = "19" + idNo.substring(6, 8);
                    // 身份证上的月份
                    uMonth = idNo.substring(8, 10);
                    // 身份证上的天
                    uDay = idNo.substring(10, 12);
                    break;
                case EIGHTEEN_ID_CARD:
                    // 身份证上的年份
                    uYear = idNo.substring(6).substring(0, 4);
                    // 身份证上的月份
                    uMonth = idNo.substring(10).substring(0, 2);
                    // 身份证上的天
                    uDay = idNo.substring(12).substring(0, 2);
                    break;
                default:
                    return 0;
            }

            int diff = nowYear - Integer.parseInt(uYear);
            if (diff == 18) {
                int uMonthNum = Integer.parseInt(uMonth);
                if (nowMonth > uMonthNum) {// 当前月份>用户出生月份，已过生日
                    age = diff;
                } else if (nowMonth < uMonthNum) {// 当前月份<用户出生月份，未过生日
                    age = diff - 1;
                } else if (nowDay >= Integer.parseInt(uDay)) {// 当前月份==用户出生月份 && 当前天>用户出身天，已过生日||当天生日
                    age = diff;
                } else {// 当前月份==用户出生月份 && 当前天<=用户出身天，未过生日
                    age = diff - 1;
                }
            } else {
                age = diff;
            }

//            if (nowMonth >= Integer.parseInt(uMonth)) {// 当前月份大于用户出身的月份表示已过生日
//                age = nowYear - Integer.parseInt(uYear) + 1;
//            } else {
//                age = nowYear - Integer.parseInt(uYear);
//            }
        }
        return age;
    }

//    /**
//     * 获取出生日期  yyyy年MM月dd日
//     *
//     * @param idNo
//     * @return
//     */
//    public static String getBirthday(String idNo) {
//        String birthday = "";
//        String year = "";
//        String month = "";
//        String day = "";
//        if (StringUtils.isNotBlank(idNo)) {
//            //15位身份证号
//            if (idNo.length() == FIFTEEN_ID_CARD) {
//                // 身份证上的年份(15位身份证为1980年前的)
//                year = "19" + idNo.substring(6, 8);
//                //身份证上的月份
//                month = idNo.substring(8, 10);
//                //身份证上的日期
//                day = idNo.substring(10, 12);
//                //18位身份证号
//            } else if (idNo.length() == EIGHTEEN_ID_CARD) {
//                // 身份证上的年份
//                year = idNo.substring(6).substring(0, 4);
//                // 身份证上的月份
//                month = idNo.substring(10).substring(0, 2);
//                //身份证上的日期
//                day = idNo.substring(12).substring(0, 2);
//            }
//            birthday = year + "年" + month + "月" + day + "日";
//        }
//        return birthday;
//    }
}
