package com.liquidnet.service.kylin.utils;

import com.fasterxml.jackson.core.type.TypeReference;
import com.liquidnet.commons.lang.util.HttpUtil;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.adam.dto.vo.AdamEntersVo;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinOrderTicketVo;
import com.liquidnet.service.kylin.dto.vo.returns.KylinOrderListVo;
import com.liquidnet.service.kylin.dto.vo.returns.PayInnerResultVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import javax.xml.ws.Response;
import java.util.List;

@Component
@Slf4j
public class OrderUtils {

    @Autowired
    private DataUtils dataUtils;
    @Value("${liquidnet.adam.url}")
    private String adamUrl;


    public String judgeOrderLimit(
            int type,
            String userId,
            String idCard,
            String performanceId,
            String ticketId,
            int performanceLimitCount,
            int performanceMemberLimitCount,
            int ticketLimitCount,
            int ticketMemberLimitCount,
            int performanceBuyCount,
            int ticketBuyCount,
            int memberType,
            int isTrueName
    ) {
        Integer[] integers;
        if (101 == type) {
            integers = festivalOrderLimit(userId, idCard, performanceId, ticketId, performanceBuyCount, ticketBuyCount, isTrueName);
        } else {
            integers = roadShowOrderLimit(userId, idCard, performanceId, ticketId, performanceBuyCount, ticketBuyCount, isTrueName);
        }
        return judgeMemberType(performanceLimitCount, performanceMemberLimitCount, ticketLimitCount, ticketMemberLimitCount, memberType, integers[0], integers[1], isTrueName);
    }

    public Integer[] roadShowOrderLimit(
            String userId,
            String idCard,
            String performanceId,
            String ticketId,
            int performanceBuyCount,
            int ticketBuyCount,
            int isTrueName
    ) {
        if (1 == isTrueName) {//实名
            performanceBuyCount += dataUtils.getIdCardPBuyCount(idCard, performanceId);
            ticketBuyCount += dataUtils.getIdCardTBuyCount(idCard, ticketId);
        } else {//非实名
            performanceBuyCount += dataUtils.getUserPBuyCount(userId, performanceId);
            ticketBuyCount += dataUtils.getUserTBuyCount(userId, ticketId);
        }
        Integer[] array = new Integer[2];
        array[0] = performanceBuyCount;
        array[1] = ticketBuyCount;
        return array;
    }

    public Integer[] festivalOrderLimit(
            String userId,
            String idCard,
            String performanceId,
            String ticketId,
            int performanceBuyCount,
            int ticketBuyCount,
            int isTrueName
    ) {
        if (1 == isTrueName) {//实名
            performanceBuyCount += dataUtils.getIdCardPBuyCount(idCard, performanceId);
            ticketBuyCount += dataUtils.getIdCardTBuyCount(idCard, ticketId);
        } else {//非实名
            performanceBuyCount += dataUtils.getUserPBuyCount(userId, performanceId);
            ticketBuyCount += dataUtils.getUserTBuyCount(userId, ticketId);
        }

        Integer[] array = new Integer[2];
        array[0] = performanceBuyCount;
        array[1] = ticketBuyCount;
        return array;
    }

    public String judgeMemberType(int performanceLimitCount, int performanceMemberLimitCount, int ticketLimitCount, int ticketMemberLimitCount, int memberType, int performanceBuyCount, int ticketBuyCount, int isTrueName) {
        if (memberType == 1 || memberType == 2) {
            if (performanceBuyCount > performanceMemberLimitCount && performanceMemberLimitCount != 0) {
                return (1 == isTrueName ? "实名制" : "本场") + "演出限购" + performanceMemberLimitCount + "张，已超出";//超过演出维度购买量
            }
            if (ticketBuyCount > ticketMemberLimitCount && ticketMemberLimitCount != 0) {
                return (1 == isTrueName ? "实名制" : "该") + "票种限购" + ticketMemberLimitCount + "张，已超出";//超过票维度购买量
            }
        } else {//非会员区间
            if (performanceBuyCount > performanceLimitCount && performanceLimitCount != 0) {
                return (1 == isTrueName ? "实名制" : "本场") + "演出限购" + performanceLimitCount + "张，已超出";//超过演出维度购买量
            }
            if (ticketBuyCount > ticketLimitCount && ticketLimitCount != 0) {
                return (1 == isTrueName ? "实名制" : "该") + "票种限购" + ticketLimitCount + "张，已超出";//超过票维度购买量
            }
        }
        return "";
    }

    /**
     * @param userId  用户id
     * @param type    1新增 2修改
     * @param orderId 订单id [需要新增或者修改的订单id]
     */
    public Boolean resetOrderListVo(String userId, Integer type, String orderId, KylinOrderTicketVo dataSingle) {
        List<KylinOrderListVo> vo = ObjectUtil.getKylinOrderListVoArrayList();
        List<KylinOrderListVo> redisVo = ObjectUtil.getKylinOrderListVoArrayList();
        KylinOrderTicketVo data;
        if (dataSingle == null) {
            data = dataUtils.getOrderTicketVo(orderId);
        } else {
            data = dataSingle;
        }

        KylinOrderListVo voItem = KylinOrderListVo.getNew().copy(data);
        List<KylinOrderListVo> redisData = dataUtils.getOrderList(userId);
        if (type == 1) {
            redisVo.add(voItem);
            if (redisData.size() > 0) {
                if (redisData.get(0).getOrderTicketsId().equals(orderId)) {
                    redisData.remove(0);
                }
            }
        }

        redisVo.addAll(redisData);
        switch (type) {
            case 1:
                for (int i = 0; i < redisVo.size(); i++) {
                    if (i == 40) {
                        break;
                    }
                    if (i == 0) {
                        vo.add(voItem);
                    } else {
                        vo.add(redisVo.get(i));
                    }
                }
                if (redisVo.size() == 0) {
                    vo.add(voItem);
                }
                dataUtils.setOrderList(userId, vo);
                return true;
            case 2:
                for (int i = 0; i < redisVo.size(); i++) {
                    if (i == 40) {
                        break;
                    }
                    if (redisVo.get(i).getOrderTicketsId().equals(orderId)) {
                        vo.add(voItem);
                    } else {
                        vo.add(redisVo.get(i));
                    }
                }
                dataUtils.setOrderList(userId, vo);
                return true;
            default:
                return false;
        }
    }


    public List<AdamEntersVo> getEnters(String entersIds, String uid){
        String returnVo = HttpUtil.get("https://testadam.zhengzai.tv"+"/adam/rsc/inquire/enters?entersIds="+entersIds+"&uid="+uid,null);
        ResponseDto<List<AdamEntersVo>> ResponseVo = JsonUtils.fromJson(returnVo, new TypeReference<ResponseDto<List<AdamEntersVo>>>() {
        });
        return ResponseVo.getData();
    }
}
