package com.liquidnet.service.feign.candy.api;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.candy.param.BackCouponParam;
import com.liquidnet.service.candy.vo.CandyCouponPreviewVo;
import com.liquidnet.service.goblin.dto.vo.GoblinUseResultVo;
import feign.hystrix.FallbackFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.List;

@Component
@FeignClient(name = "liquidnet-service-goblin",
        contextId = "FeignGoblinBaseClient", path = "",
        url = "${liquidnet.service.goblin.url}",
        fallback = FallbackFactory.Default.class)
public interface FeignGoblinBaseClient {

    //使用券 [券id] [消费内容] [价格] [spuId逗号隔开]
    @PostMapping(value = "goblin/store/coupon/useCoupon")
    ResponseDto<GoblinUseResultVo> useCoupon(@RequestParam("ucouponId") String ucouponId, @RequestParam("content") String content, @RequestParam("totalPrice") BigDecimal totalPrice, @RequestParam("spuId") String spuId, @RequestParam("uid") String uid);

    //回退券 [list<Data>] [券id ， 用户id]
    @PostMapping(value = "goblin/store/coupon/backCoupon")
    ResponseDto<Boolean> backCoupon(@RequestBody List<BackCouponParam> params);
}