package com.liquidnet.service.goblin.dto.manage.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

@ApiModel(value = "GoblinStoreMgtGoodsVo", description = "商品管理:商品列表信息")
@Data
public class GoblinStoreMgtGoodsListVo implements Serializable, Cloneable {
    private static final long serialVersionUID = -5926827517337445529L;
    @ApiModelProperty(position = 10, value = "商品ID")
    private String spuId;
    @ApiModelProperty(position = 11, value = "商品编码")
    private String spuNo;
    @ApiModelProperty(position = 12, value = "封面图片地址")
    private String coverPic;
    @ApiModelProperty(position = 13, value = "商品名称")
    private String name;
    @ApiModelProperty(position = 14, value = "商品一级分类ID[30]")
    private String cateFid;
    @ApiModelProperty(position = 15, value = "商品二级分类ID[30]")
    private String cateSid;
    @ApiModelProperty(position = 16, value = "商品三级分类ID[30]")
    private String cateTid;
    @ApiModelProperty(position = 17, value = "价格区间MIN")
    private BigDecimal priceGe;
    @ApiModelProperty(position = 18, value = "价格区间MAX")
    private BigDecimal priceLe;
    @ApiModelProperty(position = 19, value = "审核状态[0-编辑中|1-审核中|2-审核不通过|3-审核通过]")
    private String status;
    @ApiModelProperty(position = 20, value = "审核拒绝原因")
    private String reason;
    @ApiModelProperty(position = 21, value = "商品上架状态[0-待上架|1-下架|2-违规|3-上架]")
    private String shelvesStatus;

    @ApiModelProperty(position = 22, value = "总库存")
    private Integer totalStock;
    @ApiModelProperty(position = 23, value = "总销量")
    private Integer totalSales;
}
