package com.liquidnet.service.adam.service.processor;

import com.liquidnet.service.adam.dto.vo.AdamThirdPartInfoVo;
import com.liquidnet.service.adam.entity.AdamThirdParty;
import com.liquidnet.service.adam.service.DataMigrationProcessorService;
import com.liquidnet.service.adam.service.IAdamThirdPartyService;
import com.mysql.cj.jdbc.result.ResultSetImpl;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.List;

@Slf4j
@Service
public class DMThirdPartsProcessor extends DataMigrationProcessorService {
    @Autowired
    IAdamThirdPartyService adamThirdPartyService;

    @SneakyThrows
    @Override
    public void dataProcessing(Integer dg, Integer dG, String incrDt, String flg, String flu) {
        if (StringUtils.isNotEmpty(flu)) {
            log.info("DM.flush.third_party:{}", userMapper.executeForDM("adam_third_party"));

            log.info("DM.flush.AdamThirdPartInfoVo:{}", mongoTemplate.remove(Query.query(Criteria.where("_id").exists(true)), AdamThirdPartInfoVo.class.getSimpleName()).getDeletedCount());
        }

        String sqlCount = "select count(1) from (\n" +
                "                         select row_number() over (partition by uid,type order by created_at desc) rn,id,uid,open_id,avatar,nickname,type,created_at,updated_at from user_third_parts where `status`=1 and delete_tag in (0,1) and open_id<>'' and uid>0 and created_at"+(StringUtils.isBlank(incrDt) ? "<" : ">=")+"curdate()\n" +
                "                     ) t where t.rn=1";
        if (null != dg) {
            sqlCount = sqlCount + " and id%" + dG + "=" + dg;
        }
        String field = "uid,open_id,avatar,nickname,type,created_at,updated_at";
//                     1-uid,2-open_id,3-avatar,4-nickname,5-type,6-created_at,7-updated_at
        String sql = sqlCount.replace("count(1)", field);
        if ("1".equals(flg)) {
            sqlCount += " and uid in ('2026628','544327','1997335','773650','809406','1167451','423063','677171')";
            sql += " and uid in ('2026628','544327','1997335','773650','809406','1167451','423063','677171')";
        }
        sql += " order by id limit ?,?";

        Class.forName("com.mysql.cj.jdbc.Driver");
//        String url = "jdbc:mysql://pc-2ze6z2hxkug559q79.mysql.polardb.rds.aliyuncs.com:3306/passport";
        String url = "jdbc:mysql://zhengzai.mysql.polardb.rds.aliyuncs.com:3306/passport";
        Connection connection = DriverManager.getConnection(url, "readonly", "ZWDsf8Fy");

        PreparedStatement statement = connection.prepareStatement(sqlCount);
        ResultSetImpl row = (ResultSetImpl) statement.executeQuery();
        row.first();
        int ct = row.getInt(1), pSize = 1000, num = 0, tl = 0, pl = ct;
        log.info("DM.execute.counts:{}/{},{} ~ {} ----------------------------> start.sql:{}", pl, num, pSize, tl, sql);

        while (ct > 0) {
            statement = connection.prepareStatement(sql);
            int ls = pSize * num;
            statement.setInt(1, ls);
            statement.setInt(2, pSize);
            row = (ResultSetImpl) statement.executeQuery();
            log.info("DM.execute.limit {},{} - begin", ls, pSize);

            List<AdamThirdParty> thirdPartyList = new ArrayList<>();
            List<AdamThirdPartInfoVo> vos = new ArrayList<>();
            while (row.next()) {
                String uid = row.getString(1);
                if (!reUidList.contains(uid)) {
                    AdamThirdParty thirdParty = new AdamThirdParty();
                    thirdParty.setUid(uid);
                    thirdParty.setOpenId(row.getString(2));
                    thirdParty.setAvatar(row.getString(3));
                    thirdParty.setNickname(row.getString(4));
                    thirdParty.setPlatform(row.getString(5));
                    thirdParty.setState(1);
                    thirdParty.setCreatedAt(row.getLocalDateTime(6));
                    thirdParty.setUpdatedAt(row.getLocalDateTime(7));

                    AdamThirdPartInfoVo vo = AdamThirdPartInfoVo.getNew();
                    vo.setUid(thirdParty.getUid());
                    vo.setOpenId(thirdParty.getOpenId());
                    vo.setNickname(thirdParty.getNickname());
                    vo.setAvatar(thirdParty.getAvatar());
                    vo.setPlatform(thirdParty.getPlatform());
                    vo.setState(thirdParty.getState());
                    vo.setCreatedAt(thirdParty.getCreatedAt());
                    vo.setUpdatedAt(thirdParty.getUpdatedAt());

                    thirdPartyList.add(thirdParty);
                    vos.add(vo);
                }
            }
            log.info("DM.execute.limit {},{} - handle.counts:{}", ls, pSize, thirdPartyList.size());
            if (!CollectionUtils.isEmpty(thirdPartyList)) {
                tl += thirdPartyList.size();
                mongoTemplate.insert(vos, AdamThirdPartInfoVo.class.getSimpleName());
                log.info("DM.execute.limit.result:{}", adamThirdPartyService.saveBatch(thirdPartyList));
            }

            num++;
            ct -= pSize;
        }
        log.info("DM.execute.counts:{}/{},{} ~ {} ----------------------------> end", pl, num, pSize, tl);
        row.close();
        statement.close();
        connection.close();
    }
}
