package com.liquidnet.service.goblin.service.impl;

import com.github.pagehelper.PageInfo;
import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.vo.GoblinGoodsInfoVo;
import com.liquidnet.service.goblin.dto.vo.GoblinGoodsSkuInfoVo;
import com.liquidnet.service.goblin.dto.vo.GoblinNftGoodsSkuInfoVo;
import com.liquidnet.service.goblin.dto.vo.GoblinNftGoodsSpuInfoVo;
import com.liquidnet.service.goblin.service.GoblinCouponService;
import com.liquidnet.service.goblin.service.IGoblinNftGoodsAppService;
import com.liquidnet.service.goblin.util.GoblinMongoUtils;
import com.liquidnet.service.goblin.util.GoblinRedisUtils;
import com.liquidnet.service.goblin.util.QueueUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service
@Slf4j
public class GoblinNftGoodsAppServiceImpl implements IGoblinNftGoodsAppService {

    @Autowired
    private GoblinRedisUtils goblinRedisUtils;
    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    QueueUtils queueUtils;
    @Autowired
    GoblinMongoUtils mongoUtils;
    @Autowired
    GoblinCouponService goblinCouponService;

    @Override
    public ResponseDto<PageInfo<GoblinNftGoodsSkuInfoVo>> goodsList(int page) {

        int size = 20;
        //条件
        Query query = Query.query(
                Criteria.where("skuType").is(1).and("delFlg").is("0").and("status").is("3").and("shelvesStatus").is("3")
        );
        long count = mongoTemplate.count(query, GoblinGoodsSkuInfoVo.class, GoblinGoodsSkuInfoVo.class.getSimpleName());
        List<GoblinNftGoodsSkuInfoVo> skuList = goblinRedisUtils.getGoblinNftGoodsInfoListVo();
        if (null == skuList || page > 1) {
            skuList = new ArrayList<>();
            // 排序 分页
            Pageable pageable = PageRequest.of(page - 1, size, Sort.by(Sort.Direction.DESC, "createdAt"));
            query.with(pageable);

            List<GoblinGoodsSkuInfoVo> skuInfoVos = mongoTemplate.find(query, GoblinGoodsSkuInfoVo.class, GoblinGoodsSkuInfoVo.class.getSimpleName());
            for (GoblinGoodsSkuInfoVo info : skuInfoVos) {
                GoblinGoodsInfoVo goodsInfoVo = goblinRedisUtils.getGoodsInfoVo(info.getSpuId());
                GoblinNftGoodsSpuInfoVo nftGoodsSpuInfoVo = GoblinNftGoodsSpuInfoVo.getNew();
                BeanUtils.copyProperties(goodsInfoVo, nftGoodsSpuInfoVo);

                GoblinNftGoodsSkuInfoVo nftGoodsSkuInfoVo = GoblinNftGoodsSkuInfoVo.getNew();
                BeanUtils.copyProperties(info, nftGoodsSkuInfoVo);
                nftGoodsSkuInfoVo.setGoblinNftGoodsSpuInfoVo(nftGoodsSpuInfoVo);
                skuList.add(nftGoodsSkuInfoVo);
            }
            if (page <= 1) {
                goblinRedisUtils.setGoblinNftGoodsInfoListVo(skuList);
            }
        }
        PageInfo<GoblinNftGoodsSkuInfoVo> pageInfo = new PageInfo(skuList);
        pageInfo.setTotal(count);
        pageInfo.setPageSize(size);
        return ResponseDto.success(pageInfo);
    }

    @Override
    public GoblinNftGoodsSkuInfoVo goodsDetail(String skuId) {
        GoblinGoodsSkuInfoVo goodsSkuInfoVo = goblinRedisUtils.getGoodsSkuInfoVo(skuId);
        if (null != goodsSkuInfoVo && goodsSkuInfoVo.getDelFlg().equals("0") && goodsSkuInfoVo.getShelvesStatus().equals("3")) {
            Integer buyCount = 0;
            String userId = CurrentUtil.getCurrentUid();
            if (StringUtils.isNotBlank(userId)) {
                buyCount = goblinRedisUtils.getSkuCountByUid(userId, skuId);
            }
            //获取 sku 库存数量
            int stock = goblinRedisUtils.getSkuStock(null, skuId);
            log.info("skuId:{}, 库存数量:{}", skuId, stock);
            GoblinNftGoodsSkuInfoVo nftGoodsSkuInfoVo = GoblinNftGoodsSkuInfoVo.getNew();
            BeanUtils.copyProperties(goodsSkuInfoVo, nftGoodsSkuInfoVo);
            if (0 != goodsSkuInfoVo.getBuyLimit()) {
                nftGoodsSkuInfoVo.setCanBuyNum(goodsSkuInfoVo.getBuyLimit() - buyCount);
            }
            if (stock <= 0) {
                nftGoodsSkuInfoVo.setIsStock(0);
            } else {
                nftGoodsSkuInfoVo.setIsStock(1);
            }
            GoblinGoodsInfoVo goodsInfoVo = goblinRedisUtils.getGoodsInfoVo(goodsSkuInfoVo.getSpuId());
            GoblinNftGoodsSpuInfoVo nftGoodsSpuInfoVo = GoblinNftGoodsSpuInfoVo.getNew();
            BeanUtils.copyProperties(goodsInfoVo, nftGoodsSpuInfoVo);
            nftGoodsSkuInfoVo.setGoblinNftGoodsSpuInfoVo(nftGoodsSpuInfoVo);
            return nftGoodsSkuInfoVo;
        } else {
            return null;
        }
    }

    @Override
    public Boolean exchange(String code) {
        // 验证
        // 使用
        // 下单
        return true;
    }

}
