package com.liquidnet.client.admin.zhengzai.adam.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.client.admin.zhengzai.adam.service.IAdamMemberPriceAdminService;
import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.adam.constant.AdamRedisConst;
import com.liquidnet.service.adam.dto.AdamMemberPriceParam;
import com.liquidnet.service.adam.dto.vo.AdamMemberPriceVo;
import com.liquidnet.service.adam.entity.AdamMemberPrice;
import com.liquidnet.service.adam.mapper.AdamMemberPriceMapper;
import com.mongodb.client.result.UpdateResult;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.time.LocalDateTime;
import java.util.List;

@Slf4j
@Service
public class AdamMemberPriceAdminServiceImpl extends ServiceImpl<AdamMemberPriceMapper, AdamMemberPrice> implements IAdamMemberPriceAdminService {
    @Autowired
    AdamMemberPriceMapper adamMemberPriceMapper;
    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    RedisUtil redisUtil;

    @Override
//    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    public AdamMemberPriceVo add(AdamMemberPrice info) {
        List<AdamMemberPrice> existList = adamMemberPriceMapper.selectList(
                Wrappers.lambdaQuery(AdamMemberPrice.class).eq(AdamMemberPrice::getMemberId, info.getMemberId()));
        info.setMemberPriceId(CollectionUtils.isEmpty(existList) ? "101" : IDGenerator.nextSnowId().toString());
        info.setCreatedAt(LocalDateTime.now());

        adamMemberPriceMapper.insert(info);

        AdamMemberPriceVo vo = AdamMemberPriceVo.getNew().copy(info);

        mongoTemplate.insert(vo, AdamMemberPriceVo.class.getSimpleName());

        return vo;
    }

    @Override
//    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    public boolean edit(AdamMemberPriceParam param) {
        LocalDateTime now = LocalDateTime.now();

        AdamMemberPrice updateInfo = new AdamMemberPrice();
        updateInfo.setState(param.getState());
        updateInfo.setName(param.getName());
        updateInfo.setPrice(param.getPrice());
        updateInfo.setPriceFixed(param.getPriceFixed());
        updateInfo.setDays(param.getDays());
        updateInfo.setDetail(param.getDetail());
        updateInfo.setUpdatedAt(now);

        String memberId = param.getMemberId(), memberPriceId = param.getMemberPriceId();

        LambdaQueryWrapper<AdamMemberPrice> queryWrapper = Wrappers.lambdaQuery(AdamMemberPrice.class)
                .eq(AdamMemberPrice::getMemberPriceId, memberPriceId)
                .eq(AdamMemberPrice::getMemberId, memberId);
        if (adamMemberPriceMapper.update(updateInfo, queryWrapper) > 0) {
            Update updateDoc = Update.update("state", updateInfo.getState())
                    .set("name", updateInfo.getName())
                    .set("price", updateInfo.getPrice())
                    .set("priceFixed", updateInfo.getPriceFixed())
                    .set("days", updateInfo.getDays())
                    .set("detail", updateInfo.getDetail())
                    .set("updatedAt", now);
            UpdateResult updateResult = mongoTemplate.updateMulti(
                    Query.query(Criteria.where("memberPriceId").is(memberPriceId)),
                    updateDoc, AdamMemberPriceVo.class.getSimpleName()
            );
//        Document.parse(JsonUtils.toJson(updateInfo)).replace("updatedAt", now)
            if (updateResult.getModifiedCount() > 0) {
                redisUtil.del(AdamRedisConst.INFO_MEMBER_PRICE.concat(memberPriceId));
                return true;
            }
            return false;
        }
        return false;
    }
}
