package com.liquidnet.service.kylin.service.impl;

import com.liquidnet.commons.lang.util.StringUtil;
import com.liquidnet.service.goblin.dto.vo.*;
import com.liquidnet.service.kylin.dto.vo.KylinRecommendActiveRelationVo;
import com.liquidnet.service.kylin.dto.vo.KylinRecommendActiveVo;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinPerformanceVo;
import com.liquidnet.service.kylin.entity.KylinRecommendActive;
import com.liquidnet.service.kylin.service.IKylinRecommendActiveService;
import com.liquidnet.service.kylin.utils.DataUtils;
import com.liquidnet.service.kylin.utils.KylinRedisUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;

/**
 * <p>
 * 人流量检测记录表 服务实现类
 * </p>
 *
 */
@Service
public class KylinRecommendActiveServiceImpl implements IKylinRecommendActiveService {
    @Autowired
    private DataUtils dataUtils;
    @Autowired
    private KylinRedisUtils kylinRedisUtils;

    @Override
    public KylinRecommendActiveVo getRecommendById(List<KylinRecommendActive> list) {
        for(KylinRecommendActive kylinRecommendActive:list){
            //查看时间是否在当前范围内
            if(LocalDateTime.now().isAfter(kylinRecommendActive.getStartTime())&&LocalDateTime.now().isBefore(kylinRecommendActive.getEndTime())){
                KylinRecommendActiveVo kylinRecommendActiveVo = KylinRecommendActiveVo.getNew();
                BeanUtils.copyProperties(kylinRecommendActive,kylinRecommendActiveVo);
                if(StringUtil.isNotBlank(kylinRecommendActiveVo.getActiveBindId())&&null !=kylinRecommendActiveVo.getActiveType()){
                    //找到绑定的详情
                    if(kylinRecommendActiveVo.getActiveType()==3){
                        //演出
                        KylinPerformanceVo performancesInfo = dataUtils.getPerformanceVo(kylinRecommendActiveVo.getActiveBindId());
                        kylinRecommendActiveVo.setKylinPerformanceVo(performancesInfo);
                    }else if(kylinRecommendActiveVo.getActiveType()==1){
                        //NFT
                        GoblinNftGoodsSkuInfoVo goblinNftGoodsSkuInfoVo=goodsDetail(kylinRecommendActiveVo.getActiveBindId());
                        com.liquidnet.service.kylin.dto.vo.GoblinNftGoodsSkuInfoVo aNew = com.liquidnet.service.kylin.dto.vo.GoblinNftGoodsSkuInfoVo.getNew();
                        BeanUtils.copyProperties(goblinNftGoodsSkuInfoVo,aNew);
                        kylinRecommendActiveVo.setGoblinNftGoodsSkuInfoVo(aNew);
                    }else if(kylinRecommendActiveVo.getActiveType()==4){
                        //商品
                        GoblinGoodsInfoVo goblinGoodsInfoVo = kylinRedisUtils.getGoodsInfoVo(kylinRecommendActiveVo.getActiveBindId());
                        com.liquidnet.service.kylin.dto.vo.GoblinGoodsInfoVo aNew = com.liquidnet.service.kylin.dto.vo.GoblinGoodsInfoVo.getNew();
                        BeanUtils.copyProperties(goblinGoodsInfoVo,aNew);
                        kylinRecommendActiveVo.setGoblinGoodsInfoVo(aNew);
                    }else if(kylinRecommendActiveVo.getActiveType()==2){
                        //组合购
                        GoblinMixAppDetailsVo goblinMixAppDetailsVo = mixDetails(kylinRecommendActiveVo.getActiveBindId());
                        com.liquidnet.service.kylin.dto.vo.GoblinMixAppDetailsVo aNew = com.liquidnet.service.kylin.dto.vo.GoblinMixAppDetailsVo.getNew();
                        BeanUtils.copyProperties(goblinMixAppDetailsVo,aNew);
                        kylinRecommendActiveVo.setGoblinMixAppDetailsVo(aNew);
                    }
                }
                //遍历list
                List<KylinRecommendActiveRelationVo> kylinRecommendActiveVoList = kylinRecommendActiveVo.getList();
                for(KylinRecommendActiveRelationVo kylinRecommendActiveRelationVo:kylinRecommendActiveVoList){
                    if(kylinRecommendActiveRelationVo.getType()==1){
                        //NFT
                        GoblinNftGoodsSkuInfoVo goblinNftGoodsSkuInfoVo=goodsDetail(kylinRecommendActiveRelationVo.getRecommendBindId());
                        kylinRecommendActiveRelationVo.setGoblinNftGoodsSkuInfoVo(goblinNftGoodsSkuInfoVo);
                    }else if(kylinRecommendActiveRelationVo.getType()==2){
                        //组合购
                        GoblinMixAppDetailsVo goblinMixAppDetailsVo = mixDetails(kylinRecommendActiveRelationVo.getRecommendBindId());
                        kylinRecommendActiveRelationVo.setGoblinMixAppDetailsVo(goblinMixAppDetailsVo);
                    }else if(kylinRecommendActiveRelationVo.getType()==3){
                        //演出
                        KylinPerformanceVo performancesInfo = dataUtils.getPerformanceVo(kylinRecommendActiveRelationVo.getRecommendBindId());
                        kylinRecommendActiveRelationVo.setKylinPerformanceVo(performancesInfo);
                    }else if(kylinRecommendActiveRelationVo.getType()==4){
    //商品               //商品
                        GoblinGoodsInfoVo goblinGoodsInfoVo = kylinRedisUtils.getGoodsInfoVo(kylinRecommendActiveRelationVo.getRecommendBindId());
                        kylinRecommendActiveRelationVo.setGoblinGoodsInfoVo(goblinGoodsInfoVo);
                    }
                }
                return kylinRecommendActiveVo;
            }
        }
        return null;
    }

    /**
     *NFT 获取详情
     */
    public GoblinNftGoodsSkuInfoVo goodsDetail(String skuId) {
        // 1
        LocalDateTime now = LocalDateTime.now();
        HashMap<String, Object> map = kylinRedisUtils.getGoodsSkuInfoVo(now, skuId);
        if (null == map) {
            return null;
        }
        GoblinGoodsSkuInfoVo skuInfoVo = (GoblinGoodsSkuInfoVo) map.get("vo");
        Integer tagType = (Integer) map.get("tagType");
        String listId = (String) map.get("listId");
        LocalDateTime baseSaleStartTime = (LocalDateTime) map.get("baseSaleStartTime");
        LocalDateTime nextSaleStartTime = (LocalDateTime) map.get("nextSaleStartTime");
        if (kylinRedisUtils.getSkuAllStatusShow(skuInfoVo)) {

            GoblinNftGoodsSkuInfoVo nftGoodsSkuInfoVo = GoblinNftGoodsSkuInfoVo.getNew().copy(skuInfoVo, null);
            // spu信息
            GoblinGoodsInfoVo goodsInfoVo = kylinRedisUtils.getGoodsInfoVo(skuInfoVo.getSpuId());
            GoblinNftGoodsDetailSpuInfoVo nftGoodsDetailSpuInfoVo = GoblinNftGoodsDetailSpuInfoVo.getNew().copy(goodsInfoVo);
            nftGoodsSkuInfoVo.setGoblinNftGoodsDetailSpuInfoVo(nftGoodsDetailSpuInfoVo);
            // 系统时间
            nftGoodsSkuInfoVo.setSystime(LocalDateTime.now());
            nftGoodsSkuInfoVo.setTagType(tagType);
            nftGoodsSkuInfoVo.setListId(listId);
            nftGoodsSkuInfoVo.setBaseSaleStartTime(baseSaleStartTime);
            nftGoodsSkuInfoVo.setNextSaleStartTime(nextSaleStartTime);
            return nftGoodsSkuInfoVo;
        } else {
            return null;
        }
    }

    public GoblinMixAppDetailsVo  mixDetails(String mixId) {
        GoblinMixDetailsVo baseVo = kylinRedisUtils.getMixDetails(mixId);
        //GoblinStoreInfoVo storeInfoVo = redisUtils.getStoreInfoVo(baseVo.getStoreId());
        GoblinMixAppDetailsVo vo = GoblinMixAppDetailsVo.getNew().copy(baseVo, "");
        /*int stock = 0;
        for (GoblinMixDetailsItemVo item : vo.getItem()) {
            GoblinGoodsSkuInfoVo skuInfoVo = redisUtils.getGoodsSkuInfoVo(item.getSkuId());
            GoblinGoodsInfoVo spuInfoVo = redisUtils.getGoodsInfoVo(skuInfoVo.getSpuId());
            item.setSkuPic(skuInfoVo.getSkuPic());
            item.setStock(0);
            item.setSkuName(skuInfoVo.getName());
            item.setSpuName(spuInfoVo.getName());
            if (skuInfoVo.getUnbox().equals("1")) {
                List<String> relationIds = redisUtils.getGoblinMixRelationBox(item.getSkuId(), vo.getMixId());
                for (String skuId : relationIds) {
                    stock += redisUtils.getSkuStock(vo.getMixId(), skuId);
                }
            } else {
                stock += redisUtils.getSkuStock(vo.getMixId(), item.getSkuId());
            }
        }
        if (stock == 0) {
            vo.setStatus(8);
        } else {
            LocalDateTime nt = LocalDateTime.now();
            LocalDateTime st = LocalDateTime.parse(vo.getTimeStart(), DTF_YMD_HMS);
            LocalDateTime et = LocalDateTime.parse(vo.getTimeEnd(), DTF_YMD_HMS);
            if (nt.isBefore(st)) {
                vo.setStatus(9);
            } else if (nt.isAfter(et)) {
                vo.setStatus(10);
            } else {
                vo.setStatus(6);
            }
        }*/
        return vo;
    }
}
