package com.liquidnet.client.admin.web.controller.zhengzai.merchant;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.liquidnet.client.admin.common.annotation.Log;
import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.page.TableDataInfo;
import com.liquidnet.client.admin.common.enums.BusinessType;
import com.liquidnet.client.admin.common.utils.ShiroUtils;
import com.liquidnet.client.admin.zhengzai.merchant.service.IMerchantFieldAppliesAdminService;
import com.liquidnet.service.merchant.dto.admin.MerchantFieldApplyListParam;
import com.liquidnet.service.merchant.entity.MerchantFieldApplies;
import io.swagger.annotations.Api;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;


@Api(tags = "场地申请管理")
@Controller
@RequestMapping("merchant/field/apply")
public class MerchantFieldAppliesController extends BaseController {

    private final String prefix = "zhengzai/kylin/field";

    @Autowired
    IMerchantFieldAppliesAdminService merchantFieldAppliesAdminService;


    @RequiresPermissions("merchant:field:apply:view")
    @GetMapping()
    public String applyList() {
        return prefix + "/applyList";
    }


    @Log(title = "场地申请管理", businessType = BusinessType.LIST)
    @RequiresPermissions("merchant:field:apply:list")
    @PostMapping("/list")
    @ResponseBody
    public TableDataInfo list(MerchantFieldApplyListParam param) {
        startPage();
        return getDataTable(merchantFieldAppliesAdminService.list(
                Wrappers.lambdaQuery(MerchantFieldApplies.class)
                        .eq(param.getFieldApplyId().length() > 0, MerchantFieldApplies::getFieldApplyId, param.getFieldApplyId())
                        .eq(param.getApplyStatus() >= 0, MerchantFieldApplies::getApplyStatus, param.getApplyStatus())
                        .eq(!param.getApplyType().equals("all"), MerchantFieldApplies::getApplyType, param.getApplyType())
                        .select(
                                MerchantFieldApplies::getFieldApplyId, MerchantFieldApplies::getApplyStatus, MerchantFieldApplies::getApplyType, MerchantFieldApplies::getReject, MerchantFieldApplies::getUid, MerchantFieldApplies::getFieldId,
                                MerchantFieldApplies::getName, MerchantFieldApplies::getLogo,
                                MerchantFieldApplies::getCreatedAt
                        )
        ));
    }

    @Log(title = "场地申请管理", businessType = BusinessType.DETAIL)
    @RequiresPermissions("merchant:field:apply:detail")
    @GetMapping(value = "/details/{fieldApplyId}")
    public String detail(@PathVariable("fieldApplyId") String fieldApplyId, ModelMap mmap) {
        String authId = ShiroUtils.getUserId().toString();
        String authName = ShiroUtils.getLoginName();
        return prefix + "/details";
    }


}
