package com.liquidnet.service.chime.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: ChimeUserInfoDto
 * @Package com.liquidnet.service.chime.dto
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2021/9/8 15:17
 */
@Data
public class ChimeUserInfoDto {
    private static final long serialVersionUID = 5325511589667456213L;
    @ApiModelProperty(position = 0, value = "用户ID[64]")
    private String userId;
    @ApiModelProperty(position = 1, value = "性别")
    private String sex;
    @ApiModelProperty(position = 2, value = "用户昵称")
    private String userName;
    @ApiModelProperty(position = 3, value = "用户手机号")
    private String userMobile;
    @ApiModelProperty(position = 4, value = "头像")
    private String avatar;
    @ApiModelProperty(position = 4, value = "封面")
    private String userCover;
    @ApiModelProperty(position = 5, value = "在场ID")
    private String joinPerformanceId;
    @ApiModelProperty(position = 5, value = "用户标签")
    private List<ChimeTagVo> userTags;

    private static final ChimeUserInfoDto obj = new ChimeUserInfoDto();
    public static ChimeUserInfoDto getNew() {
        try {
            return (ChimeUserInfoDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new ChimeUserInfoDto();
        }
    }
}
