package com.liquidnet.service.chime.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: ChimeUserListQueryReqDto
 * @Package com.liquidnet.service.chime.dto
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2021/9/9 12:05
 */
@Data
public class ChimeUserListQueryReqDto {
    @ApiModelProperty(value = "演出ID", example = "")
    private String performanceId;
    @ApiModelProperty(value = "性别", example = "")
    private String sex;
    @ApiModelProperty(value = "兴趣标签", example = "")
    private String tags;

    @ApiModelProperty(value = "每页记录数", example = "20")
    @NotNull(message = "每页记录数不能为空")
    private Integer pageSize;

    @ApiModelProperty(value = "当前页", example = "0")
    @NotNull(message = "当前页不能为空")
    private Integer pageNum;

    @ApiModelProperty(value = "排序字段", hidden = true)
    private String orderItem;

    @ApiModelProperty(value = "排序方式", hidden = true)
    private String orderSc;

    private static final ChimeUserListQueryReqDto obj = new ChimeUserListQueryReqDto();

    public static ChimeUserListQueryReqDto getNew() {
        try {
            return (ChimeUserListQueryReqDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new ChimeUserListQueryReqDto();
        }
    }
}
