package com.liquidnet.service.kylin.dto.param;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.util.List;

@Api
@Data
public class PayOrderParam {
    @ApiModelProperty(value = "演出id")
    @NotNull(message = "演出ID不能为空")
    private String performanceId;
    @ApiModelProperty(value = "场次id")
    @NotNull(message = "场次ID不能为空")
    private String timeId;
    @ApiModelProperty(value = "票种id")
    @NotNull(message = "票种ID不能为空")
    private String ticketId;
    @ApiModelProperty(value = "数量")
    @NotNull(message = "数量不能为空")
    @Min(value = 1,message = "数量不能小于0")
    private Integer number;

//    @ApiModelProperty(value = "是否学生票")
//    @NotNull(message = "必传")
//    private Integer isStudent;
    @ApiModelProperty(value = "是否电子票")
    private Integer isElectronic;
    @ApiModelProperty(value = "是否快递票")
    private Integer isExpress;

    @ApiModelProperty(value = "收货地址id")
    private String addressId;
    @ApiModelProperty(value = "入场人id数组")
    private List<String> enterIdList;
    @ApiModelProperty(value = "代理id")
    @NotNull(message = "代理ID不能为空")
    private String agentId;
    @ApiModelProperty(value = "快递类型 1寄付 2到付")
    @NotNull(message = "快递方式不能为空")
    @Max(value = 2, message = "快递方式无效")
    @Min(value = 1, message = "快递方式无效")
    private Integer expressType;


    @ApiModelProperty(value = "支付类型")
    @NotNull(message = "支付类型不能为空")
    private String payType;
    @ApiModelProperty(value = "支付来源")
    @NotNull(message = "支付来源不能为空")
    private String deviceFrom;
    @ApiModelProperty(value = "openId")
    private String openId;
    @ApiModelProperty(value = "showUrl")
    private String showUrl;
    @ApiModelProperty(value = "returnUrl")
    private String returnUrl;
}
