package com.liquidnet.service.goblin.service;

import com.github.pagehelper.PageInfo;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.vo.GoblinNftExActivityVo;
import com.liquidnet.service.goblin.dto.vo.GoblinNftSkuVo;
import com.liquidnet.service.goblin.dto.vo.PageInfoVo;
import com.liquidnet.service.goblin.param.GoblinNftExActivityParam;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

public interface IGoblinNftExActivityService {

    /**
     * 新增nft活动
     *
     * @param goblinNftExActivityParam
     * @return
     */
    ResponseDto<Object> add(GoblinNftExActivityParam goblinNftExActivityParam);

    /**
     * 分页查询
     *
     * @param goblinNftExActivityParam
     * @return
     */
    PageInfoVo pageList(GoblinNftExActivityParam goblinNftExActivityParam);

    /**
     * 根据活动id获取活动下商品
     *
     * @param activityId
     * @return
     */
    List<GoblinNftSkuVo> selectNftSkuByActivityId(String activityId);

    /**
     * excel导出
     *
     * @param httpServletResponse
     * @param goblinNftExActivityParam
     */
    void excel(HttpServletResponse httpServletResponse, GoblinNftExActivityParam goblinNftExActivityParam);
}
