package com.liquidnet.service.consumer.adam.config;

import com.liquidnet.common.cache.redis.config.RedisStreamConfig;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.consumer.adam.receiver.ConsumerChimeUserOperationDisLikeRdsReceiver;
import com.liquidnet.service.consumer.adam.receiver.ConsumerChimeUserOperationLikeRdsReceiver;
import lombok.var;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.stream.Consumer;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.ReadOffset;
import org.springframework.data.redis.connection.stream.StreamOffset;
import org.springframework.data.redis.stream.StreamMessageListenerContainer;
import org.springframework.data.redis.stream.Subscription;

@Configuration
public class ConsumerChimeRedisStreamConfig extends RedisStreamConfig {
    @Autowired
    ConsumerChimeUserOperationDisLikeRdsReceiver consumerChimeUserOperationDisLikeRdsReceiver;
    @Autowired
    ConsumerChimeUserOperationLikeRdsReceiver consumerChimeUserOperationLikeRdsReceiver;

    /**
     * 划卡-喜欢
     *
     * @param listenerContainer
     * @param t
     * @return
     */
    private Subscription receiveUserOperationLike(StreamMessageListenerContainer<String, MapRecord<String, String, String>> listenerContainer, int t) {
        return listenerContainer.receiveAutoAck(Consumer.from(MQConst.ChimeQueue.USER_OPERATION_LIKE.getGroup(), getConsumerName(MQConst.ChimeQueue.USER_OPERATION_LIKE.name() + t)),
                StreamOffset.create(MQConst.ChimeQueue.USER_OPERATION_LIKE.getKey(), ReadOffset.lastConsumed()), consumerChimeUserOperationLikeRdsReceiver);
    }

    /**
     * 划卡-不喜欢
     *
     * @param listenerContainer
     * @param t
     * @return
     */
    private Subscription receiveUserOperationDisLike(StreamMessageListenerContainer<String, MapRecord<String, String, String>> listenerContainer, int t) {
        return listenerContainer.receiveAutoAck(Consumer.from(MQConst.ChimeQueue.USER_OPERATION_DISLIKE.getGroup(), getConsumerName(MQConst.ChimeQueue.USER_OPERATION_DISLIKE.name() + t)),
                StreamOffset.create(MQConst.ChimeQueue.USER_OPERATION_DISLIKE.getKey(), ReadOffset.lastConsumed()), consumerChimeUserOperationDisLikeRdsReceiver);
    }

    /* —————————————————————————— ｜ —————————————————————————— ｜ —————————————————————————— */

    /* -------------------------------------------------------- ｜ 划卡-喜欢 */

    @Bean
    public Subscription subscriptionUserOperationLike0(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveUserOperationLike(listenerContainer, 0);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionUserOperationLike1(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveUserOperationLike(listenerContainer, 1);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionUserOperationLike2(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveUserOperationLike(listenerContainer, 2);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionUserOperationLike3(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveUserOperationLike(listenerContainer, 3);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionUserOperationLike4(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveUserOperationLike(listenerContainer, 4);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionUserOperationLike5(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveUserOperationLike(listenerContainer, 5);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionUserOperationLike6(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveUserOperationLike(listenerContainer, 6);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionUserOperationLike7(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveUserOperationLike(listenerContainer, 7);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionUserOperationLike8(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveUserOperationLike(listenerContainer, 8);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionUserOperationLike9(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveUserOperationLike(listenerContainer, 9);
        listenerContainer.start();
        return subscription;
    }

    /* -------------------------------------------------------- ｜ 划卡-不喜欢 */

    @Bean
    public Subscription subscriptionUserOperationDisLike0(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveUserOperationDisLike(listenerContainer, 0);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionUserOperationDisLike1(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveUserOperationDisLike(listenerContainer, 1);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionUserOperationDisLike2(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveUserOperationDisLike(listenerContainer, 2);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionUserOperationDisLike3(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveUserOperationDisLike(listenerContainer, 3);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionUserOperationDisLike4(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveUserOperationDisLike(listenerContainer, 4);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionUserOperationDisLike5(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveUserOperationDisLike(listenerContainer, 5);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionUserOperationDisLike6(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveUserOperationDisLike(listenerContainer, 6);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionUserOperationDisLike7(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveUserOperationDisLike(listenerContainer, 7);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionUserOperationDisLike8(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveUserOperationDisLike(listenerContainer, 8);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionUserOperationDisLike9(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveUserOperationDisLike(listenerContainer, 9);
        listenerContainer.start();
        return subscription;
    }

    /* -------------------------------------------------------- ｜  */

}
