package com.liquidnet.service.dragon.dto;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: DragonOrdersDto
 * @Package com.liquidnet.service.dragon.dto
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2021/7/13 19:36
 */
@Data
public class DragonOrdersDto implements Serializable, Cloneable {
    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * order_id
     */
    private String orderId;

    /**
     * status
     */
    private Integer status;

    /**
     * code
     */
    private String code;

    /**
     * type
     */
    private String type;

    /**
     * price
     */
    private BigDecimal price;

    /**
     * name
     */
    private String name;

    /**
     * detail
     */
    private String detail;

    /**
     * order_code
     */
    private String orderCode;

    /**
     * client_ip
     */
    private String clientIp;

    /**
     * notify_url
     */
    private String notifyUrl;

    /**
     * 通知状态(0初始化 1通知成功 2 通知失败 3通知超时)
     */
    private Integer notifyStatus;

    /**
     * payment_type
     */
    private String paymentType;

    /**
     * payment_id
     */
    private String paymentId;

    /**
     * payment_at
     */
    private LocalDateTime paymentAt;

    /**
     * finished_at
     */
    private LocalDateTime finishedAt;

    /**
     * created_at
     */
    private LocalDateTime createdAt;

    /**
     * updated_at
     */
    private LocalDateTime updatedAt;

    /**
     * deleted_at
     */
    private LocalDateTime deletedAt;

    private static final DragonOrdersDto obj = new DragonOrdersDto();

    public static DragonOrdersDto getNew() {
        try {
            return (DragonOrdersDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new DragonOrdersDto();
        }
    }
}
