package com.liquidnet.service.sweet.handler;

import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.bean.WxMaMessage;
import cn.binarywang.wx.miniapp.message.WxMaMessageHandler;
import cn.binarywang.wx.miniapp.message.WxMaXmlOutMessage;
import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.sweet.config.WechatMpConfigure;
import com.liquidnet.service.sweet.utils.QueueUtils;
import lombok.extern.slf4j.Slf4j;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.session.WxSessionManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.LinkedList;
import java.util.Map;

/**
 * <p>
 * 关注
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-07-31 5:06 下午
 */
@Component
@Slf4j
public class ApplySubscribeHandler implements WxMaMessageHandler {

    @Autowired
    private QueueUtils queueUtils;
    @Autowired
    WechatMpConfigure wechatMpConfigure;

    @Override
    public WxMaXmlOutMessage handle(WxMaMessage message, Map<String, Object> context, WxMaService service, WxSessionManager sessionManager) throws WxErrorException {
        log.info("ApplySubscribeHandler message{},context{},service{},sessionManager{}", message, context, service, sessionManager);
        String openId = message.getFromUser();
        String templateId = "ue0Ehbk0u-akw4hIx_xUsrElT4gFOgc_Ch-CSsJlXas";
        String targetId = "4567654235465";
        String appletType = "4";

        LinkedList<String> sqls = CollectionUtil.linkedListString();
        LinkedList<Object[]> sqlsDataA = CollectionUtil.linkedListObjectArr();
        sqls.add(SqlMapping.get("sweet_applet_sub_msg.insert"));
        sqlsDataA.add(new Object[]{
                IDGenerator.nextSnowId(), openId, templateId, targetId, appletType
        });
        queueUtils.sendMsgByRedis(MQConst.SweetQueue.SWEET_REMIND_INSERT.getKey(),
                SqlMapping.gets(sqls, sqlsDataA));

        return null;
    }
}
