package com.liquidnet.service.account.wallet.service.impl;

import com.liquidnet.service.account.wallet.entity.FinChannel;
import com.liquidnet.service.account.wallet.mapper.FinChannelMapper;
import com.liquidnet.service.account.wallet.service.FinChannelService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service
public class FinChannelServiceImpl implements FinChannelService {
    private static final Logger log = LoggerFactory.getLogger(FinChannelServiceImpl.class);
    @Autowired
    private FinChannelMapper channelMapper;

    @Override
    public FinChannel query(String channelId) {
        return channelMapper.selectByPrimaryKey(channelId);
    }

    @Override
    public Map<String, String> queryForClickList() {
        List<FinChannel> channelList = channelMapper.selectForClickList();
        return channelList.parallelStream().collect(Collectors.toMap(FinChannel::getChannelId, FinChannel::getChannelName));
    }
}
