package com.liquidnet.service;

import org.mybatis.spring.annotation.MapperScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.support.SpringBootServletInitializer;
import org.springframework.cloud.client.circuitbreaker.EnableCircuitBreaker;
import org.springframework.cloud.netflix.eureka.EnableEurekaClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.core.env.Environment;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.transaction.annotation.TransactionManagementConfigurer;

import javax.sql.DataSource;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;

@SpringBootApplication(scanBasePackages = {"com.liquidnet"})
@EnableEurekaClient
@EnableFeignClients
@EnableCircuitBreaker
@EnableScheduling
@MapperScan(basePackages = "com.liquidnet.service.bank")
@EnableTransactionManagement
@EnableAsync
@EnableConfigurationProperties
public class ServiceBankApplication extends SpringBootServletInitializer implements TransactionManagementConfigurer, CommandLineRunner {

    private Logger logger = LoggerFactory.getLogger(ServiceBankApplication.class);

    @Autowired
    private DataSource dataSource;

    @Autowired
    private Environment environment;

    public static void main(String[] args) {
        SpringApplication.run(ServiceBankApplication.class, args);
    }

    @Override
    public PlatformTransactionManager annotationDrivenTransactionManager() {
        logger.info("配置事务管理###########################");
        return new DataSourceTransactionManager(dataSource);
    }

    @Override
    public void run(String... strings) throws Exception {
        try {
            logger.info("\n----------------------------------------------------------\n\t" +
                            "Application '{}' is running! Access URLs:\n\t" +
                            "Local: \t\thttp://127.0.0.1:{}\n\t" +
                            "External: \thttp://{}:{}/doc.html\n\t" +
                            "Profile(s): \t{}\n----------------------------------------------------------",
                    environment.getProperty("spring.application.name"),
                    environment.getProperty("server.port"),
                    InetAddress.getLocalHost().getHostAddress(),
                    environment.getProperty("server.port"),
                    Arrays.toString(environment.getActiveProfiles()));
        } catch (UnknownHostException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected SpringApplicationBuilder configure(SpringApplicationBuilder builder) {
        return builder.sources(this.getClass());
    }

}
