package com.liquidnet.client.admin.web.controller.shop;


import com.alibaba.fastjson.JSON;
import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.zhengzai.shop.service.imp.GoblinFrontBannerServiceImpl;
import com.liquidnet.service.goblin.entity.GoblinFrontBanner;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;

/**
 * <p>
 * 轮播图 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2021-12-27
 */

@Api(tags = "banner管理")
@RestController
@RequestMapping("/frontBanner")
public class GoblinFrontBannerController extends BaseController {
    @Autowired
    GoblinFrontBannerServiceImpl goblinFrontBannerService;
    /**
     * @author zhangfuxin
     * @Description:添加banner
     * @date 2021/12/27 下午1:22
     */
    @PostMapping("create")
    @ApiOperation(value = "增加banner")
    @ResponseBody
    public AjaxResult create( @RequestBody GoblinFrontBanner goblinFrontBanner) {
        logger.info("增加banner{}", JSON.toJSONString(goblinFrontBanner));
        boolean result=goblinFrontBannerService.save(goblinFrontBanner);
        if (result ) {
            return success("操作成功");
        } else {
            return error("操作失败");
        }
    }

}
