package com.liquidnet.service.goblin.entity;

import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 首页导航栏

 * </p>
 *
 * @author liquidnet
 * @since 2021-12-27
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class GoblinFrontNavigation implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    private Long mid;

    /**
     * 图片路径或id
     */
    private String picUrl;

    /**
     * 标题
     */
    private String title;

    /**
     * 商品id
     */
    private String spuId;

    /**
     * 展示形式：1、一行2、二行
     */
    private Integer displayType;

    /**
     * 分类
     */
    private String categoryType;

    /**
     * 活动链接
     */
    private String activityUrl;

    /**
     * 1、分类2、专题3、商品单品
     */
    private Integer navigationType;

    /**
     * 顺序
     */
    private Integer indexs;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 修改时间
     */
    private LocalDateTime updateTime;

    /**
     * 导航id
     */
    private String navigationId;

    /**
     * 0未删除1已删除
     */
    private Integer delTag;


}
