package com.liquidnet.service.kylin.mapper;

import com.liquidnet.service.kylin.entity.KylinOrderTickets;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;

import java.util.HashMap;
import java.util.List;

/**
 * <p>
 * 订单 Mapper 接口
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-05-25 14:00 下午
 */
public interface KylinOrderTicketsMapper extends BaseMapper<KylinOrderTickets> {

    // 查询演出订单能退款的总金额和总订单数量
    HashMap<String, Object> getPriceNum(String targetId);

    // 查询微信、支付宝对应的订单金额、快递费金额
    Double getTotalPrice(String targetId, String selectFields, String[] paymentType);

    // 获取订单和购票信息
    List getOrderList(String targetId, int mid, int limitNum);
}
