package com.liquidnet.service.kylin.service.impl.admin;

import com.fasterxml.jackson.databind.JsonNode;
import com.liquidnet.commons.lang.util.HttpUtil;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.kylin.entity.KylinOrderTicketEntities;
import com.liquidnet.service.kylin.entity.KylinOrderTickets;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 * <p>
 * 后台退款 服务实现类
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-05-26 13:00 下午
 */
@Service
public class KylinRefundHttpSubmitServiceImpl {

    @Async
    public void httpApply(KylinOrderTickets orderInfo, List<KylinOrderTicketEntities> entitiesList, HashMap<String, Object> otherParam, String refundBatchId) throws Exception {
        String postUrl = "apply";

        // 构造退款数据
        List<String> ticketEntityIds = null;
        if (!entitiesList.isEmpty()) {
            for (KylinOrderTicketEntities v : entitiesList) {
                String orderTicketsId = v.getOrderTicketEntitiesId();
                ticketEntityIds.add(orderTicketsId);
            }
        }

        HashMap<String, Object> refundData = new HashMap();
        refundData.put("ticket_entity_ids", ticketEntityIds);
        refundData.put("matter_items", new ArrayList()); //搭售不处理
        if (ticketEntityIds.isEmpty()) {
            throw new Exception("查询详情出错");
        }

        // 发起退款申请
        MultiValueMap<String, String> headers = new LinkedMultiValueMap();
        headers.add("Authorization", otherParam.get("token").toString());

        MultiValueMap<String, String> formParams = new LinkedMultiValueMap();
        formParams.add("order_type", "order_ticket");
        formParams.add("order_id", orderInfo.getOrderTicketsId());
        formParams.add("batch_id", refundBatchId);
        formParams.add("reason", otherParam.get("reason").toString());
        formParams.add("refund_data", JsonUtils.toJson(refundData));

        /*HashMap<String, Object> postParams = new HashMap();
        postParams.put("headers", headers);
        postParams.put("form_params", formParams);*/

        // 请求提审接口参数
        String postResult = HttpUtil.post(postUrl, formParams, headers);
        JsonNode postResultNew = JsonUtils.fromJson(postResult, JsonNode.class);
        // 请求提审接口结果
        if (postResultNew.get("message").toString() != "OK") {
            throw new Exception("申请退款出错");
        }
    }

    @Async
    public void httpStatus(List<String> refundIds, HashMap<String, Object> otherParam) throws Exception {
        String postUrl = "reapply";

        // 发起退款申请
        MultiValueMap<String, String> headers = new LinkedMultiValueMap();
        headers.add("Authorization", otherParam.get("token").toString());

        MultiValueMap<String, String> formParams = new LinkedMultiValueMap();
        formParams.put("ids", refundIds);
        String reject = otherParam.get("reject").toString();
        if (reject.isEmpty()) reject = "";
        String refuse = otherParam.get("refuse").toString();
        if (refuse.isEmpty()) refuse = "";
        String status = (String) otherParam.get("status");
        if (status.isEmpty()) status = "0";
        formParams.add("reject", reject);
        formParams.add("status", status);
        formParams.add("refuse", refuse);

        // 请求提审接口参数
        String postResult = HttpUtil.post(postUrl, formParams, headers);
        JsonNode postResultNew = JsonUtils.fromJson(postResult, JsonNode.class);
        // 请求提审接口结果
        if (postResultNew.get("message").toString() != "OK") {
            throw new Exception("操作出错");
        }
    }

}
