package com.liquidnet.service.bank.currencycloud.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.currencycloud.client.CurrencyCloudClient;
import com.currencycloud.client.exception.ApiException;
import com.currencycloud.client.model.Contact;
import com.liquidnet.common.exception.constant.ErrorCode;
import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.bank.currencycloud.dto.BankCcContactParam;
import com.liquidnet.service.bank.currencycloud.entity.BankCcContact;
import com.liquidnet.service.bank.currencycloud.mapper.BankCcContactMapper;
import com.liquidnet.service.bank.currencycloud.service.IBankCcContactService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.time.LocalDateTime;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author lightnet
 * @since 2020-09-08
 */
@Service("bankCcContactService")
@Slf4j
public class BankCcContactServiceImpl implements IBankCcContactService {

    @Value("${liquidnet.conf.currencycloud.email_address}")
    private String emailAddress;

    @Autowired
    CurrencyCloudClient currencyCloudClient;

    @Autowired
    BankCcContactMapper bankCcContactMapper;

    @Override
    @Transactional
    public ResponseDto<BankCcContact> createContact(BankCcContactParam param) {
        String logFx = param.getLoginId() + ",cc create contact.";
        try {
            String accountId = param.getAccountId();
            String firstName = param.getFirstName();
            String lastName = param.getLastName();
            String phoneNumber = param.getPhoneNumber();
            Contact contact = Contact.create(accountId, firstName, lastName, emailAddress, phoneNumber);
            // default enable
            contact.setStatus("enabled");
            contact.setLoginId(param.getLoginId());

            log.info(logFx + "request contact=[{}]", JSON.toJSONString(contact));
            Contact contactResp = currencyCloudClient.createContact(contact);
            log.info(logFx + "response contact=[{}]", contactResp.toString());

            BankCcContact bankCcContact = new BankCcContact();
            BeanUtils.copyProperties(contactResp, bankCcContact);
            // 持久化数据库
            bankCcContact.setCreateTime(LocalDateTime.now());
            bankCcContactMapper.insert(bankCcContact);
            return ResponseDto.success(bankCcContact);

        } catch (ApiException e) {
            log.error(logFx + "api eroor, errorCode=[{}],errors=[{}]", e.getErrorCode(), e.getErrors());
            return ResponseDto.failure(e.getErrorCode(), e.getMessage());
        } catch (Exception e) {
            log.error(logFx + "exception eroor:[{}]", JSON.toJSONString(e));
            return ResponseDto.failure(ErrorCode.HTTP_SYSTEM_ERROR);
        }

    }

    @Override
    public BankCcContact getByAccountId(String accountId) {
        QueryWrapper<BankCcContact> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(BankCcContact::getAccountId, accountId);
        return bankCcContactMapper.selectOne(queryWrapper);
    }

}
