package com.liquidnet.service.goblin.entity;

import java.math.BigDecimal;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;

import java.time.LocalDateTime;
import java.io.Serializable;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 订单退单退款表
 * </p>
 *
 * @author liquidnet
 * @since 2021-12-27
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class GoblinBackOrder implements Serializable, Cloneable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * 订单退单表id
     */
    private String backOrderId;

    /**
     * 退款单号
     */
    private String backCode;

    /**
     * 订单id
     */
    private String orderId;

    /**
     * 订单编号
     */
    private String orderCode;

    /**
     * 商铺id
     */
    private String storeId;

    /**
     * 用户id
     */
    private String userId;

    /**
     * 退货的单品ID多个用,分开  退款的时候不需要，因为退款只能整单退1001-1,1002-3 表示单品id为1001 的单品退货1件 单品id为1002的单品退货3件
     */
    private String skuIdNums;

    /**
     * 类型[1-退款|2-退货]
     */
    private Integer type;

    /**
     * 退款／退货原因[1-不想买了|2-收货人信息有误|3-未按指定时间发货|4-其他|5-不想买了|6-商品质量问题|7-收到商品与描述不符|8-其他|9-系统自动申请]
     */
    private String reason;

    /**
     * 问题说明
     */
    private String describes;

    /**
     * 申请凭据[0-没有任何凭据|1-有发票|2-有质检报告]
     */
    private Integer credential;

    /**
     * 返回方式[1-快递返回]目前只有快递返回 （退货的时候用户给商城寄送商品）
     */
    private Integer backType;

    /**
     * 退货时候实际退款金额
     */
    private BigDecimal realBackPrice;

    /**
     * 退款快递费
     */
    private BigDecimal backPriceExpress;

    /**
     * 上传的退款凭证或者质检发票 多个图片 用, 隔开
     */
    private String pics;

    /**
     * 退款／退货状态[1-退款申请(用户发送退款请求)|2-退款成功(商家同意退款)|3-退款拒绝(商家拒绝退款)|4-退货申请(用户发起退货请求)|5-退货拒绝(商家拒绝退货)|6-退货审核通过等待用户填写物流(商家审核通过，等待用户寄回商品)|7-待收货(用户已确认)|8-退货完成(商家收货并且同意退款给用户)|9-退货失败(商家不同意退款)
     */
    private Integer status;

    /**
     * 是否预存款支付[0-否|1-是]
     */
    private Integer preDepositPay;

    /**
     * 物流公司名称
     */
    private String logisCompanyName;

    /**
     * 物流单号
     */
    private String mailNo;

    private String refuseReason;

    private LocalDateTime auditAt;

    private LocalDateTime expireAt;

    private LocalDateTime refundAt;

    private LocalDateTime refuseAt;

    private int refusedSize;

    private LocalDateTime createdAt;

    private LocalDateTime updatedAt;

    private String comment;

    private static final GoblinBackOrder obj = new GoblinBackOrder();

    public static GoblinBackOrder getNew() {
        try {
            return (GoblinBackOrder) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new GoblinBackOrder();
    }
}
