package com.liquidnet.service.kylin.constant;

/**
 * <p>
 * Kylin表状态常量定义
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-05-25 6:38 下午
 */
public class KylinTableStatusConst {
    // 批量退款
    public static final Integer STATUS_APPLY = 1; // 1申请退款
    public static final Integer STATUS_CANCEL = 2; // 2取消退款
    public static final Integer STATUS_OPERATE_REJECT = 3; // 3运营驳回审核
    public static final Integer STATUS_OPERATE_ADOPT = 4; // 4运营通过审核
    public static final Integer STATUS_FINANCE_REJECT = 5; // 5财务驳回审核
    public static final Integer STATUS_FINANCE_ADOPT = 6; // 6财务通过审核

    public static final Integer STATUS_TARGET_TYPE = 1; // 演出

    // 退款
    public static final Integer ORDER_REFUND_STATUS_APPLY                  = 0;                // 客服(待审核)，用户(正在退款)
    public static final Integer ORDER_REFUND_STATUS_APPROVED               = 1;                // 客服(已通过)，用户(正在退款)
    public static final Integer ORDER_REFUND_STATUS_CANCEL                 = 2;                // 客服(已取消)，用户(取消退款，恢复正常订单)
    public static final Integer ORDER_REFUND_STATUS_REFUNDING              = 3;                // 客服(正在退款)，用户(正在退款)
    public static final Integer ORDER_REFUND_STATUS_REFUNDED               = 4;                // 客服(退款成功)，用户(完成退款，部分退款为正常订单，全额退款为退款订单)
    public static final Integer ORDER_REFUND_STATUS_REJECT                 = 5;                // 客服(被审核员驳回)，用户(正在退款)
    public static final Integer ORDER_REFUND_STATUS_ERROR                  = 6;                // 客服(退款失败)，用户(正在退款)
    public static final Integer ORDER_REFUND_STATUS_UNFILLED               = 7;                // 客服(等待退款)，用户(正在退款)
    public static final Integer ORDER_REFUND_STATUS_REFUSE                 = 8;                // 客服(被执行员拒绝)，用户(正在退款)

    public static final Integer ORDER_REFUND_TYPE_APPLY                    = 0;                // 人工申请类型的退款，可以取消退款，退款完成需返还库存
    public static final Integer ORDER_REFUND_TYPE_AUTO                     = 1;                // 自动申请类型的退款，无法取消退款，退款完成不返还库存

    // 订单状态
    public static final Integer STATUS_UNPAID = 0;    // 待付款
    public static final Integer STATUS_PAID = 1;    // 已付款
    public static final Integer STATUS_CLOSE = 2;    // 已关闭
    public static final Integer STATUS_DELETE = -1;   // 关闭后用户主动删除
    public static final Integer STATUS_REFUND = 3;    // 正在退款
    public static final Integer STATUS_REFUNDED = 4;    // 已退款

    public static final Integer STATUS_WAIT_CLOSE = 5;    // 待关闭

    // 订单转赠状态
    public static final Integer TRANSFER_STATUS_NONE = 0;    // 无
    public static final Integer TRANSFER_STATUS_ACCEPT = 1;    // 接受
    public static final Integer TRANSFER_STATUS_GRANT = 2;    // 赠予
}
