package com.liquidnet.service.platform.controller.smile;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.platform.service.impl.kylin.DataImpl;
import com.liquidnet.service.platform.service.impl.smile.SellDataInfoImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;


@Api(tags = "销量数据")
@RestController
@RequestMapping("sell")
public class SellDataController {

    @Autowired
    private DataImpl data;
    @Autowired
    private SellDataInfoImpl sellDataInfo;

    @PostMapping("sellData")
    @ApiOperation("销量数据列表")
    public ResponseDto<Boolean> sellData() {
        sellDataInfo.setData();
        return ResponseDto.success();
    }
    @PostMapping("commissionData")
    @ApiOperation("佣金")
    public ResponseDto<Boolean> commissionData() {
        sellDataInfo.setCommission();
        return ResponseDto.success();
    }


}
