package com.liquidnet.service.galaxy.service.impl;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.galaxy.dto.param.*;
import com.liquidnet.service.galaxy.router.strategy.GalaxyRouterStrategyContext;
import com.liquidnet.service.galaxy.service.IGalaxyTradeQueryService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: GalaxyUserServiceImpl
 * @Package com.liquidnet.service.galaxy.service.impl
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/4/7 12:09
 */
@Slf4j
@Service("galaxyTradeQueryService")
public class GalaxyTradeQueryServiceImpl implements IGalaxyTradeQueryService {
    @Autowired
    private GalaxyRouterStrategyContext galaxyRouterStrategyContext;

    @Override
    public ResponseDto<GalaxyQueryNftInfoRespDto> queryNftInfo(GalaxyQueryNftInfoReqDto reqDto) {
        return galaxyRouterStrategyContext.getTradeQueryStrategy(reqDto.getRouterType()).queryNftInfo(reqDto);
    }

    @Override
    public ResponseDto<GalaxyQueryTransNftInfoRespDto> queryTransNftInfo(GalaxyQueryTransNftInfoReqDto reqDto) {
        return galaxyRouterStrategyContext.getTradeQueryStrategy(reqDto.getRouterType()).queryTransNftInfo(reqDto);
    }

    @Override
    public ResponseDto<GalaxyQueryNftTradeListRespDto> queryNftTradeList(GalaxyQueryNftTradeListReqDto reqDto) {
        return galaxyRouterStrategyContext.getTradeQueryStrategy(reqDto.getRouterType()).queryNftTradeList(reqDto);
    }

    @Override
    public ResponseDto<GalaxyQuerySeriesInfoRespDto> querySeriesInfo(GalaxyQuerySeriesInfoReqDto reqDto) {
        return galaxyRouterStrategyContext.getTradeQueryStrategy(reqDto.getRouterType()).querySeriesInfo(reqDto);
    }

    @Override
    public ResponseDto<GalaxyQueryUserSeriesNftListRespDto> queryUserSeriesNftList(GalaxyQueryUserSeriesNftListReqDto reqDto) {
        return galaxyRouterStrategyContext.getTradeQueryStrategy(reqDto.getRouterType()).queryUserSeriesNftList(reqDto);
    }

    @Override
    public ResponseDto<GalaxyQueryUserTradeAllListRespDto> queryUserTradeAllList(GalaxyQueryUserTradeAllListReqDto reqDto) {
        return galaxyRouterStrategyContext.getTradeQueryStrategy(reqDto.getRouterType()).queryUserTradeAllList(reqDto);
    }

    @Override
    public ResponseDto<GalaxyQueryUserTradeInListRespDto> queryUserTradeInList(GalaxyQueryUserTradeInListReqDto reqDto) {
        return galaxyRouterStrategyContext.getTradeQueryStrategy(reqDto.getRouterType()).queryUserTradeInList(reqDto);
    }

    @Override
    public ResponseDto<GalaxyQueryUserTradeOutListRespDto> queryUserTradeOutList(GalaxyQueryUserTradeOutListReqDto reqDto) {
        return galaxyRouterStrategyContext.getTradeQueryStrategy(reqDto.getRouterType()).queryUserTradeOutList(reqDto);
    }
}
