package com.liquidnet.service.sweet.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * YB报名表
 * </p>
 *
 * @author jiangxiulong
 * @since 2022-07-29
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class SweetYbActivity implements Serializable {

    private static final long serialVersionUID = -2081186417971841992L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * 活动id
     */
    private String activityId;

    /**
     * 活动名称
     */
    private String title;

    /**
     * 封面图
     */
    private String cover;

    /**
     * 状态[0-未开始|6-开始|7-下线|9-结束]
     */
    private Integer status;

    /**
     * 开始时间
     */
    private LocalDateTime startTime;

    /**
     * 结束时间
     */
    private LocalDateTime endTime;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    /**
     * 更新时间
     */
    private LocalDateTime updatedAt;

    private static final SweetYbActivity obj = new SweetYbActivity();

    public static SweetYbActivity getNew() {
        try {
            return (SweetYbActivity) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new SweetYbActivity();
        }
    }

}
