package com.liquidnet.service.goblin.dto.manage;

import com.liquidnet.commons.lang.constant.LnsRegex;
import com.liquidnet.service.goblin.dto.GoblinGoodsSpecDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.*;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

@ApiModel(value = "GoblinStoreMgtGoodsAddSkuParam", description = "商品管理:添加商品:添加SKU入参")
@Data
public class GoblinStoreMgtGoodsAddSkuParam implements Serializable {
    private static final long serialVersionUID = 6657596593310537491L;
    @ApiModelProperty(position = 10, required = false, value = "单品ID[编辑时必传]")
    private String skuId;
    @ApiModelProperty(position = 10, required = false, value = "单品编码[默认为系统编码，也可手动输入商家自己的编码]")
    @Pattern(regexp = LnsRegex.Valid.ALPHABET_NUMBER_UNDER_50, message = "单品编码格式或长度有误")
    private String skuNo;
    @ApiModelProperty(position = 10, required = false, value = "单品条码")
    @Pattern(regexp = LnsRegex.Valid.ALPHABET_NUMBER_32, message = "单品条码格式或长度有误")
    private String skuBarCode;
    @ApiModelProperty(position = 10, required = false, value = "ERP商家编码")
    @Size(max = 40, message = "ERP商家编码长度限制40")
    private String skuErpCode;
    @ApiModelProperty(position = 10, value = "ERP托管[0-否|1-是]，默认0")
    @Pattern(regexp = "\\b(0|1)\\b", message = "ERP托管参数无效")
    private String erpHosting;
    @ApiModelProperty(position = 10, required = false, value = "ERP仓库编号")
    @Size(max = 40, message = "ERP仓库编号长度限制40")
    private String erpWarehouseNo;
    @ApiModelProperty(position = 11, required = true, value = "单品默认图片的url[256]")
    @NotBlank(message = "单品图片不能为空")
    private String skuPic;
    @ApiModelProperty(position = 12, required = true, value = "单品规格信息")
    @NotNull(message = "规格信息不能为空")
    @Valid
    private List<GoblinGoodsSpecDto> skuSpecList;
    @ApiModelProperty(position = 13, required = false, value = "单品销售价-原价[20,2]")
    private BigDecimal sellPrice;
    @ApiModelProperty(position = 14, required = true, value = "单品现价[20,2]")
    @NotNull(message = "单品现价不能为空")
    @Min(value = 0, message = "单品现价不能小于0")
    private BigDecimal price;
    @ApiModelProperty(position = 15, required = true, value = "单品会员价格[20,2]")
    @NotNull(message = "单品会员价格不能为空")
    @Min(value = 0, message = "单品会员价格不能小于0")
    private BigDecimal priceMember;
    @ApiModelProperty(position = 16, required = false, value = "单品的重量[20,2]")
    private BigDecimal weight;
    @ApiModelProperty(position = 17, required = true, value = "总库存")
    @Min(value = 0, message = "总库存不能小于0")
    private Integer stock;
    @ApiModelProperty(position = 18, required = false, value = "预警库存")
    private Integer warningStock;
    @ApiModelProperty(position = 19, required = false, value = "ISBN，针对CD/图书等[100]")
    private String skuIsbn;
    @ApiModelProperty(position = 20, required = true, value = "购买限制[0-全部用户|1-仅会员|2-指定用户]")
    @NotNull(message = "购买限制不能为空")
    private String buyFactor;
    @ApiModelProperty(position = 21, required = false, value = "购买限制人员名单[购买限制为2-指定用户时必填]")
    private String buyRoster;
    @ApiModelProperty(position = 22, required = false, value = "限量[0-无限制|X:限购数量]")
    private Integer buyLimit;
    @ApiModelProperty(position = 23, required = false, value = "单品有效期[yyyy-MM-dd HH:mm:ss]")
    @Pattern(regexp = LnsRegex.Valid.DATETIME_FULL, message = "单品有效期格式有误")
    private String skuValidity;
    @ApiModelProperty(position = 24, value = "自定义展示[0-默认展示|1-隐藏不可购买]")
    private String skuAppear;
}
