package com.liquidnet.service.galaxy.dto.param;

import com.liquidnet.commons.lang.util.JsonUtils;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import java.io.Serializable;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: NFT转让
 * @class: GalaxyNftTransferReqDto
 * @Package com.liquidnet.service.galaxy.dto.param
 * @Copyright: LightNet @ Copyright (c) 2022
 * @date 2022/8/12 18:42
 */
@ApiModel(value = "GalaxyNftTransferReqDto", description = "NFT转让")
@Data
public class GalaxyNftTransferReqDto extends GalaxyBaseReqDto implements Serializable,Cloneable {

    /**
     * nft转让流水号
     */
    @ApiModelProperty(position = 1, required = true, value = "nft转让流水号(保证唯一)，不超过30个字符")
    @NotBlank(message = "nft转让流水号(平台订单id)不能为空")
    @Size(min = 2, max = 30, message = "nft转让流水号(平台订单id)限制2-30位且不能包含特殊字符")
    private String transOrderId;

    /**
     * 用户id
     */
    @ApiModelProperty(position = 1, required = true, value = "用户ID[30]")
    @NotBlank(message = "用户ID不能为空！")
    @Size(min = 1, max = 30, message = "用户ID限制2-30位且不能包含特殊字符")
    private String userId;

    /**
     * 接收用户id
     */
    @ApiModelProperty(position = 1, required = true, value = "接收用户ID[30]")
    @NotBlank(message = "接收用户ID不能为空！")
    @Size(min = 1, max = 30, message = "用户ID限制2-30位且不能包含特殊字符")
    private String receiveUserId;

    /**
     * nftId
     */
    @ApiModelProperty(position = 1, required = true, value = "nft唯一id")
    @NotBlank(message = "nft唯一id不能为空！")
    private String nftId;

    /**
     * reqTimestamp
     */
    @ApiModelProperty(position = 3, required = true, value = "请求时间戳(格式为：2022-04-07 12:12:12)")
    @NotBlank(message = "请求时间戳不能为空！")
    private String reqTimestamp;

    @Override
    public String toString(){
        return JsonUtils.toJson(this);
    }

    private static final GalaxyNftTransferReqDto obj = new GalaxyNftTransferReqDto();

    public static GalaxyNftTransferReqDto getNew() {
        try {
            return (GalaxyNftTransferReqDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GalaxyNftTransferReqDto();
        }
    }
}
