package com.liquidnet.service.sweet.controller.five;


import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.entity.SweetManualSortMdsk;
import com.liquidnet.service.sweet.service.ISweetManualSortMdskService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 电子宣传手册显示内容表 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2021-08-09
 */
@Api(tags = "电子手册显示tag_MDSK")
@RestController
@RequestMapping("/mdsk/sweet-manual-sort")
public class SweetManualSortFiveController {

    @Autowired
    private ISweetManualSortMdskService sweetManualSortMdskService;


    @PostMapping("add")
    @ApiOperation("操作 电子手册tag")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "manualId", value = "电子手册id", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "content", value = "内容 例子(POSITION_1,POSITION_2)", required = true)
    })
    public ResponseDto<Boolean> changeStatus(@RequestParam() String manualId,
                                             @RequestParam() String content) {
        return sweetManualSortMdskService.add(manualId, content);
    }

    @GetMapping("get")
    @ApiOperation("获取 电子手册tag")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "manualId", value = "电子手册id", required = true)
    })
    public ResponseDto<SweetManualSortMdsk> changeStatus(@RequestParam() String manualId) {
        return sweetManualSortMdskService.get(manualId);
    }

}
